#
# TABLE STRUCTURE FOR: admin_groups
#

DROP TABLE IF EXISTS `admin_groups`;

CREATE TABLE `admin_groups` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('1', 'webmaster', '<ul>\r\n	<li>Maintain websites and web applications for clients and businesses.</li>\r\n	<li>Ensure the web servers, hardware and software are operating accurately.</li>\r\n</ul>\r\n');
INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('2', 'Administrators', '<p>Administrator</p>\n');
INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('3', 'Accounting', '<p>The <strong>accounting department</strong> is responsible for recording and reporting the cash flow transactions of a company. This <strong>department</strong> has some key <strong>roles</strong> and responsibilities, including <strong>accounts</strong> receivable, <strong>accounts</strong> payable, payroll, financial reporting, and maintaining financial controls.</p>\r\n\r\n<p>&nbsp;</p>\r\n');
INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('4', 'Managers', '');
INSERT INTO `admin_groups` (`id`, `name`, `description`) VALUES ('5', 'Front_Office', '');


#
# TABLE STRUCTURE FOR: admin_login_attempts
#

DROP TABLE IF EXISTS `admin_login_attempts`;

CREATE TABLE `admin_login_attempts` (
  `id` int(11) unsigned NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: admin_users
#

DROP TABLE IF EXISTS `admin_users`;

CREATE TABLE `admin_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varchar(15) NOT NULL,
  `username` varchar(100) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `activation_code` varchar(40) DEFAULT NULL,
  `forgotten_password_code` varchar(40) DEFAULT NULL,
  `forgotten_password_time` int(11) unsigned DEFAULT NULL,
  `remember_code` varchar(40) DEFAULT NULL,
  `created_on` int(11) unsigned NOT NULL,
  `last_login` int(11) unsigned DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `Id_No` int(255) NOT NULL,
  `Phone_No` int(255) NOT NULL,
  `Image` varchar(255) NOT NULL,
  `office` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO `admin_users` (`id`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `Id_No`, `Phone_No`, `Image`, `office`) VALUES ('1', '127.0.0.1', 'webmaster', '$2y$08$QRcA9nuZh/5e.e0hfHeYN.zKfyZuUeBbgmE/aWDsjgsVMG1GXY5C.', NULL, 'mwaspython@gmail.com', NULL, NULL, NULL, 'WdZiZwjtVLzacOHoLnqdYO', '1451900190', '1615804098', '1', 'Joel', 'Mwangi', '0', '2147483647', '397ef-property.jpg', '7');
INSERT INTO `admin_users` (`id`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `Id_No`, `Phone_No`, `Image`, `office`) VALUES ('2', '127.0.0.1', 'Geomara', '$2y$08$aGEUipNTjzBpbzQLvlkHT.gDMdveBfjqd39q85EfZ36JqN4elclQC', NULL, NULL, NULL, NULL, NULL, NULL, '1610449780', NULL, '1', 'Mara', '', '0', '0', '49528-property.jpg', '1 ');


#
# TABLE STRUCTURE FOR: admin_users_groups
#

DROP TABLE IF EXISTS `admin_users_groups`;

CREATE TABLE `admin_users_groups` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `group_id` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('1', '1', '1');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('7', '3', '3');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('20', '12', '2');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('27', '13', '4');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('28', '14', '5');
INSERT INTO `admin_users_groups` (`id`, `user_id`, `group_id`) VALUES ('29', '2', '2');


#
# TABLE STRUCTURE FOR: advance
#

DROP TABLE IF EXISTS `advance`;

CREATE TABLE `advance` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `employee` varchar(255) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `month` varchar(255) NOT NULL,
  `year` year(4) NOT NULL,
  `date` date NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `paymentmethod` varchar(255) NOT NULL,
  `paymentref` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `advance` (`id`, `employee`, `full_name`, `month`, `year`, `date`, `amount`, `paymentmethod`, `paymentref`) VALUES ('1', 'JORA004', 'FELIX WAMBUA KIOKO', 'DECEMBER', '2018', '2018-12-05', '2500.00', 'Mobile Money', 'Mpesa: MJROITJ54');


#
# TABLE STRUCTURE FOR: api_access
#

DROP TABLE IF EXISTS `api_access`;

CREATE TABLE `api_access` (
  `id` int(11) unsigned NOT NULL,
  `key` varchar(40) NOT NULL DEFAULT '',
  `controller` varchar(50) NOT NULL DEFAULT '',
  `date_created` datetime DEFAULT NULL,
  `date_modified` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: api_keys
#

DROP TABLE IF EXISTS `api_keys`;

CREATE TABLE `api_keys` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `key` varchar(40) NOT NULL,
  `level` int(2) NOT NULL,
  `ignore_limits` tinyint(1) NOT NULL DEFAULT 0,
  `is_private_key` tinyint(1) NOT NULL DEFAULT 0,
  `ip_addresses` text DEFAULT NULL,
  `date_created` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `api_keys` (`id`, `user_id`, `key`, `level`, `ignore_limits`, `is_private_key`, `ip_addresses`, `date_created`) VALUES ('1', '0', 'anonymous', '1', '1', '0', NULL, '1463388382');
INSERT INTO `api_keys` (`id`, `user_id`, `key`, `level`, `ignore_limits`, `is_private_key`, `ip_addresses`, `date_created`) VALUES ('1', '0', 'anonymous', '1', '1', '0', NULL, '1463388382');


#
# TABLE STRUCTURE FOR: api_limits
#

DROP TABLE IF EXISTS `api_limits`;

CREATE TABLE `api_limits` (
  `id` int(11) NOT NULL,
  `uri` varchar(255) NOT NULL,
  `count` int(10) NOT NULL,
  `hour_started` int(11) NOT NULL,
  `api_key` varchar(40) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: api_logs
#

DROP TABLE IF EXISTS `api_logs`;

CREATE TABLE `api_logs` (
  `id` int(11) NOT NULL,
  `uri` varchar(255) NOT NULL,
  `method` varchar(6) NOT NULL,
  `params` text DEFAULT NULL,
  `api_key` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `time` int(11) NOT NULL,
  `rtime` float DEFAULT NULL,
  `authorized` varchar(1) NOT NULL,
  `response_code` smallint(3) DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: attendances
#

DROP TABLE IF EXISTS `attendances`;

CREATE TABLE `attendances` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `Employee_Id` varchar(255) NOT NULL,
  `Employee_Name` varchar(255) NOT NULL,
  `Time_In` datetime NOT NULL,
  `Time_Out` datetime NOT NULL,
  `Date` date NOT NULL,
  `Status` varchar(255) NOT NULL,
  `Ref_Code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=latin1;

INSERT INTO `attendances` (`id`, `Employee_Id`, `Employee_Name`, `Time_In`, `Time_Out`, `Date`, `Status`, `Ref_Code`) VALUES ('59', '4', 'Hall Makter', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-05-02', 'Present', 'AD0012018-05-02');
INSERT INTO `attendances` (`id`, `Employee_Id`, `Employee_Name`, `Time_In`, `Time_Out`, `Date`, `Status`, `Ref_Code`) VALUES ('62', '5', 'Lorreta Lynch', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2018-05-02', 'Absent', 'AD0052018-05-02');


#
# TABLE STRUCTURE FOR: businesspayment_category
#

DROP TABLE IF EXISTS `businesspayment_category`;

CREATE TABLE `businesspayment_category` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO `businesspayment_category` (`id`, `name`, `description`) VALUES ('4', 'BUSINESS  PAYMENT TRANSACTIONS', 'Port Charges');


#
# TABLE STRUCTURE FOR: businesspayments
#

DROP TABLE IF EXISTS `businesspayments`;

CREATE TABLE `businesspayments` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `Payment_Title` varchar(255) NOT NULL,
  `Category` varchar(255) NOT NULL,
  `Amount` decimal(25,2) NOT NULL,
  `VAT` decimal(25,2) DEFAULT NULL,
  `total` decimal(25,2) NOT NULL,
  `Date` date NOT NULL,
  `Note` text NOT NULL,
  `Document` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=70 DEFAULT CHARSET=latin1;

INSERT INTO `businesspayments` (`id`, `Payment_Title`, `Category`, `Amount`, `VAT`, `total`, `Date`, `Note`, `Document`) VALUES ('65', 'Port Charges', 'BUSINESS PAYMENT TRANSACTIONS', '17655.75', '2824.92', '20480.67', '2018-08-20', 'KPA', 'Receipt no. KPA0006893936 M-Pesa transaction MHK66PELOU');
INSERT INTO `businesspayments` (`id`, `Payment_Title`, `Category`, `Amount`, `VAT`, `total`, `Date`, `Note`, `Document`) VALUES ('63', 'Port Charges', 'BUSINESS PAYMENT TRANSACTIONS', '149834.44', '23973.51', '173807.95', '2018-08-05', 'KPA', 'Receipt no. KPA0006889344 Dated 5/8/2018');
INSERT INTO `businesspayments` (`id`, `Payment_Title`, `Category`, `Amount`, `VAT`, `total`, `Date`, `Note`, `Document`) VALUES ('68', 'Port Charges (CFS Charges )', 'BUSINESS PAYMENT TRANSACTIONS', '6210.00', '994.00', '7204.00', '2018-09-01', 'Makupa Transit Shade ltd', 'Receipt no.365169');
INSERT INTO `businesspayments` (`id`, `Payment_Title`, `Category`, `Amount`, `VAT`, `total`, `Date`, `Note`, `Document`) VALUES ('69', 'Port Charges (CFS Charges)', 'BUSINESS PAYMENT TRANSACTIONS', '223042.50', '35686.80', '258729.30', '2018-09-01', 'Makupa Transit Shade Ltd', 'Receipt no. 365162');


#
# TABLE STRUCTURE FOR: cashpayments
#

DROP TABLE IF EXISTS `cashpayments`;

CREATE TABLE `cashpayments` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `customer` varchar(255) NOT NULL,
  `subtotal` decimal(25,2) NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `amountwords` varchar(255) NOT NULL,
  `service` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `vat_type` varchar(255) NOT NULL,
  `vat_amount` decimal(25,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `cashpayments` (`id`, `customer`, `subtotal`, `amount`, `amountwords`, `service`, `date`, `vat_type`, `vat_amount`) VALUES ('4', 'ROMANIAN CHILDREN\'S MISSION', '10000.00', '10000.00', 'TEN THOUSAND ONLY', 'IDF & KBS CD', '2018-07-17', 'zero_rated', '0.00');
INSERT INTO `cashpayments` (`id`, `customer`, `subtotal`, `amount`, `amountwords`, `service`, `date`, `vat_type`, `vat_amount`) VALUES ('5', 'JOSEPH MACHARIA MOHUHI', '3000.00', '3480.00', 'THREE THOUSAND FOUR HUNDRED AND EIGHTY SHILLINGS ONLY', 'AGENCY FEE ENTRY 2018 MSA 6929375', '2018-07-18', 'exclusive', '480.00');


#
# TABLE STRUCTURE FOR: cdr
#

DROP TABLE IF EXISTS `cdr`;

CREATE TABLE `cdr` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `depositpaid` decimal(25,2) NOT NULL,
  `refunded` decimal(25,2) NOT NULL,
  `refunddate` date NOT NULL,
  `container` varchar(255) NOT NULL,
  `shippingline` varchar(255) NOT NULL,
  `invoiceno` varchar(255) NOT NULL,
  `paidmethod` varchar(255) NOT NULL,
  `refundmethod` varchar(255) NOT NULL,
  `blno` varchar(255) NOT NULL,
  `paidcurrency` varchar(255) NOT NULL,
  `refundcurrency` varchar(255) NOT NULL,
  `refundref` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO `cdr` (`id`, `date`, `depositpaid`, `refunded`, `refunddate`, `container`, `shippingline`, `invoiceno`, `paidmethod`, `refundmethod`, `blno`, `paidcurrency`, `refundcurrency`, `refundref`) VALUES ('7', '2018-10-26', '500.00', '50065.00', '2018-11-30', 'MSCU6941509', 'Oceanfreight(k) ltd', 'IMINVO1715118MSC', 'Cash', 'Bank Transfer', 'MEDUDC039424', 'Usd', 'Ksh', 'Transaction Ref. no. 400017991');


#
# TABLE STRUCTURE FOR: creditnotes
#

DROP TABLE IF EXISTS `creditnotes`;

CREATE TABLE `creditnotes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer` varchar(255) NOT NULL,
  `creditnote_date` date NOT NULL,
  `invoice_no` varchar(255) NOT NULL,
  `vat_type` varchar(255) NOT NULL,
  `vat_amount` decimal(25,2) NOT NULL,
  `total` decimal(25,2) NOT NULL,
  `totalamount` decimal(25,2) NOT NULL,
  `paid` decimal(25,2) NOT NULL,
  `balance` decimal(25,2) NOT NULL,
  `qty1` varchar(255) DEFAULT NULL,
  `pp1` text DEFAULT NULL,
  `amt1` decimal(25,2) DEFAULT NULL,
  `qty2` varchar(255) DEFAULT NULL,
  `pp2` text DEFAULT NULL,
  `amt2` decimal(25,2) DEFAULT NULL,
  `qty3` varchar(255) DEFAULT NULL,
  `pp3` text DEFAULT NULL,
  `amt3` decimal(25,2) DEFAULT NULL,
  `qty4` varchar(255) DEFAULT NULL,
  `pp4` text DEFAULT NULL,
  `amt4` decimal(25,2) DEFAULT NULL,
  `qty5` varchar(255) DEFAULT NULL,
  `pp5` text DEFAULT NULL,
  `amt5` decimal(25,2) DEFAULT NULL,
  `qty6` varchar(255) DEFAULT NULL,
  `pp6` varchar(255) DEFAULT NULL,
  `amt6` decimal(25,2) DEFAULT NULL,
  `qty7` varchar(255) DEFAULT NULL,
  `pp7` varchar(255) DEFAULT NULL,
  `amt7` decimal(25,2) DEFAULT NULL,
  `qty8` varchar(255) DEFAULT NULL,
  `pp8` varchar(255) DEFAULT NULL,
  `amt8` decimal(25,2) DEFAULT NULL,
  `qty9` varchar(255) DEFAULT NULL,
  `pp9` varchar(255) DEFAULT NULL,
  `amt9` decimal(25,2) DEFAULT NULL,
  `tt1` decimal(25,2) NOT NULL,
  `tt2` decimal(25,2) NOT NULL,
  `tt3` decimal(25,2) NOT NULL,
  `tt4` decimal(25,2) NOT NULL,
  `tt5` decimal(25,2) NOT NULL,
  `tt6` decimal(25,2) DEFAULT NULL,
  `tt7` decimal(25,2) DEFAULT NULL,
  `tt8` decimal(25,2) DEFAULT NULL,
  `tt9` decimal(25,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `creditnotes` (`id`, `customer`, `creditnote_date`, `invoice_no`, `vat_type`, `vat_amount`, `total`, `totalamount`, `paid`, `balance`, `qty1`, `pp1`, `amt1`, `qty2`, `pp2`, `amt2`, `qty3`, `pp3`, `amt3`, `qty4`, `pp4`, `amt4`, `qty5`, `pp5`, `amt5`, `qty6`, `pp6`, `amt6`, `qty7`, `pp7`, `amt7`, `qty8`, `pp8`, `amt8`, `qty9`, `pp9`, `amt9`, `tt1`, `tt2`, `tt3`, `tt4`, `tt5`, `tt6`, `tt7`, `tt8`, `tt9`) VALUES ('1', 'STEEL MAKERS LTD', '2018-08-06', '221', 'inclusive', '2240.00', '16240.00', '16240.00', '0.00', '16240.00', '1', '   ENTRY 2018 MSA 697060', '8120.00', '1', '   ENTRY 2018 MSA 6970572', '8120.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '8120.00', '8120.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `creditnotes` (`id`, `customer`, `creditnote_date`, `invoice_no`, `vat_type`, `vat_amount`, `total`, `totalamount`, `paid`, `balance`, `qty1`, `pp1`, `amt1`, `qty2`, `pp2`, `amt2`, `qty3`, `pp3`, `amt3`, `qty4`, `pp4`, `amt4`, `qty5`, `pp5`, `amt5`, `qty6`, `pp6`, `amt6`, `qty7`, `pp7`, `amt7`, `qty8`, `pp8`, `amt8`, `qty9`, `pp9`, `amt9`, `tt1`, `tt2`, `tt3`, `tt4`, `tt5`, `tt6`, `tt7`, `tt8`, `tt9`) VALUES ('2', 'STEEL MAKERS LTD', '2018-09-26', '226', 'exclusive', '1120.00', '7000.00', '8120.00', '0.00', '8120.00', '1', ' Entry 2018 MSA 6979415', '7000.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '7000.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00');
INSERT INTO `creditnotes` (`id`, `customer`, `creditnote_date`, `invoice_no`, `vat_type`, `vat_amount`, `total`, `totalamount`, `paid`, `balance`, `qty1`, `pp1`, `amt1`, `qty2`, `pp2`, `amt2`, `qty3`, `pp3`, `amt3`, `qty4`, `pp4`, `amt4`, `qty5`, `pp5`, `amt5`, `qty6`, `pp6`, `amt6`, `qty7`, `pp7`, `amt7`, `qty8`, `pp8`, `amt8`, `qty9`, `pp9`, `amt9`, `tt1`, `tt2`, `tt3`, `tt4`, `tt5`, `tt6`, `tt7`, `tt8`, `tt9`) VALUES ('3', 'EVENT HOUSE LIMITED', '2018-12-20', '245', 'exclusive', '675.84', '4224.00', '4899.84', '0.00', '4899.84', '1', ' ENTRY 2018 MSA 7033422', '4224.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '', ' ', '0.00', '4224.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00');


#
# TABLE STRUCTURE FOR: customers
#

DROP TABLE IF EXISTS `customers`;

CREATE TABLE `customers` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` int(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=25 DEFAULT CHARSET=latin1;

INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('12', 'ROMANIAN CHILDREN\'S MISSION', 'BOX 423-90400 Mwingi', 'romaniachildrenmissionschools@gmail.com', '753672146');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('5', 'STEEL MAKERS LTD', 'P.O BOX 44574 -00100 NBI', 'nbo@steelmakers.com/msa@steelmakers.com', '720633733');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('6', 'FAST LANE LOGISTICS SYSTEMS LIMITED', 'NAIROBI', 'fastlanelogistics@yahoo.com', '722517884');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('7', 'SAFARICOM LIMITED', 'NAIROBI', 'business.support@safaricom.co.ke', '722002222');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('8', 'CHROMAWAVE ENTERPRISE LIMITED', 'P.O BOX 2893--10100 Nyahururu', 'gitawa2006@yahoo.com', '726761244');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('9', 'JIJENGE QUARRY AND CONSRUCTION LIMITED', 'BOX 3476--30100 ELDORET', 'mainaeden@gmail.com', '722315291');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('10', 'ORIGINAL ELECTRONICS AND TECHNOLOGY CO.LTD', '2189 NBI CITY SOUTH', 'originalelectronicsltd@gmail.com', '746117001');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('13', 'JOSEPH MACHARIA MOHUHI', 'BOX 1105- 10200 MURANG\'A', 'jmohuhi@gmail.com', '703415391');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('16', 'SIMBA AFRICA TRADING CO.LTD', 'BOX 47662 NAIROBI', 'simbaafricacoltd@gmail.com', '70628921');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('15', 'CYRUS GACHUKI NJAU', 'BOX 223-00232 ELDORET', 'cyrusnjau2010@gmail.com', '722445610');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('17', 'HANGZHOU AGROCHEMICAL.  IND .EA LTD', 'BOX 17121 -20100 NAKURU', 'info@hanzhoukenya.com', '718290745');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('18', 'PHILIP NGANGA', 'Box 663-00518 Nairobi', 'philipnganga@gmail.com', '722605302');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('19', 'AFRICAN  COFFEE ROSTERS  EPZ  LTD', 'BOX 535 -00204  Athi River', 'kbu@acr.co.ke', '780202005');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('20', 'EVENT HOUSE LIMITED', 'P.O BOX 39203--00623 NAIROBI', 'info@eventhousekenya.com', '723889888');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('21', 'MICHEAL AGABA', 'P.O Box 60853 Nairobi', 'agabamic@gmail.com', '780886458');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('22', 'KENMEAT EPZ LIMITED', 'BOX 58627- 00200 NAIROBI', 'N/A', '720800944');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('23', 'ABABRA TRADERS LIMITED', 'BOX  NYERI', 'ababra2018@yahoo.com', '722296506');
INSERT INTO `customers` (`id`, `name`, `address`, `email`, `phone`) VALUES ('24', 'GLOBAL REAL MILES TD', 'BOX 78218 -00507 NAIROBI', 'globalrealmilesltd@yahoo.com', '0');


#
# TABLE STRUCTURE FOR: debitnotes
#

DROP TABLE IF EXISTS `debitnotes`;

CREATE TABLE `debitnotes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer` varchar(255) NOT NULL,
  `debitnote_date` date NOT NULL,
  `invoice_no` varchar(255) NOT NULL,
  `vat_type` varchar(255) NOT NULL,
  `vat_amount` decimal(25,2) NOT NULL,
  `total` decimal(25,2) NOT NULL,
  `totalamount` decimal(25,2) NOT NULL,
  `paid` decimal(25,2) NOT NULL,
  `balance` decimal(25,2) NOT NULL,
  `qty1` varchar(255) DEFAULT NULL,
  `pp1` text DEFAULT NULL,
  `amt1` decimal(25,2) DEFAULT NULL,
  `qty2` varchar(255) DEFAULT NULL,
  `pp2` text DEFAULT NULL,
  `amt2` decimal(25,2) DEFAULT NULL,
  `qty3` varchar(255) DEFAULT NULL,
  `pp3` text DEFAULT NULL,
  `amt3` decimal(25,2) DEFAULT NULL,
  `qty4` varchar(255) DEFAULT NULL,
  `pp4` text DEFAULT NULL,
  `amt4` decimal(25,2) DEFAULT NULL,
  `qty5` varchar(255) DEFAULT NULL,
  `pp5` text DEFAULT NULL,
  `amt5` decimal(25,2) DEFAULT NULL,
  `qty6` varchar(255) DEFAULT NULL,
  `pp6` varchar(255) DEFAULT NULL,
  `amt6` decimal(25,2) DEFAULT NULL,
  `qty7` varchar(255) DEFAULT NULL,
  `pp7` varchar(255) DEFAULT NULL,
  `amt7` decimal(25,2) DEFAULT NULL,
  `qty8` varchar(255) DEFAULT NULL,
  `pp8` varchar(255) DEFAULT NULL,
  `amt8` decimal(25,2) DEFAULT NULL,
  `qty9` varchar(255) DEFAULT NULL,
  `pp9` varchar(255) DEFAULT NULL,
  `amt9` decimal(25,2) DEFAULT NULL,
  `tt1` decimal(25,2) NOT NULL,
  `tt2` decimal(25,2) NOT NULL,
  `tt3` decimal(25,2) NOT NULL,
  `tt4` decimal(25,2) NOT NULL,
  `tt5` decimal(25,2) NOT NULL,
  `tt6` decimal(25,2) DEFAULT NULL,
  `tt7` decimal(25,2) DEFAULT NULL,
  `tt8` decimal(25,2) DEFAULT NULL,
  `tt9` decimal(25,2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: departments
#

DROP TABLE IF EXISTS `departments`;

CREATE TABLE `departments` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=latin1;

INSERT INTO `departments` (`id`, `name`, `description`) VALUES ('8', 'Accounting', 'The Accounting Department is responsible for recording and reporting the cash flow transactions of a company. This department has some key roles and responsibilities, including accounts receivable, accounts payable, payroll, financial reporting, and maintaining financial controls.');
INSERT INTO `departments` (`id`, `name`, `description`) VALUES ('10', 'Administration', 'The main job responsibility of an Administrator is to ensure the efficient performance of all departments in an organization. They provide motivation to the work force and make them realize the goals of the organization.');
INSERT INTO `departments` (`id`, `name`, `description`) VALUES ('12', 'Human Resource', 'The Human Resources Department handles many necessary functions of the business. It is instrumental in providing labour law compliance, record keeping, hiring and training, compensation, relational assistance and help with handling specific performance issues.');
INSERT INTO `departments` (`id`, `name`, `description`) VALUES ('13', 'Operations', 'Operations management (OM) is the business function responsible for managing the process of creation of goods and services. It involves planning, organizing, co-ordinating, and controlling all the resources needed to produce a company\'s goods and services.');
INSERT INTO `departments` (`id`, `name`, `description`) VALUES ('14', 'Marketing and Sales', 'Marketing and Sales position is responsible for planning and implementing sales, marketing and product development programs, both short and long range, targeted toward existing and new markets by performing the following duties personally or through subordinates');


#
# TABLE STRUCTURE FOR: designations
#

DROP TABLE IF EXISTS `designations`;

CREATE TABLE `designations` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=latin1;

INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('17', 'Assistant Operations Supervisor', 'Operations');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('18', 'Head of Operations ', 'Operations');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('19', 'Human Resource Manager', 'Human Resource');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('14', 'Conductor/Turn Boy', 'Operations');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('16', 'Receptionist/Secretary', 'Administration');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('8', ' Director ', 'Administration');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('10', 'Operations Supervisor', 'Operations');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('11', 'Accountant', 'Accounts Department');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('12', 'Port Clerk', 'Operations');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('13', 'Driver', 'Operations');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('20', 'C.E.O/ Managing Director', 'Administration');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('21', 'Finance Manager', 'Accounts');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('22', 'Head Marketing and Sales', 'Marketing');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('23', 'Marketing and Sales Officer 1', 'Marketing');
INSERT INTO `designations` (`id`, `name`, `description`) VALUES ('25', 'Company Secretary', 'Legal Department');


#
# TABLE STRUCTURE FOR: employees
#

DROP TABLE IF EXISTS `employees`;

CREATE TABLE `employees` (
  `Employee_Id` varchar(255) NOT NULL,
  `Passport_Photo` varchar(255) NOT NULL,
  `Full_Name` varchar(255) NOT NULL,
  `Email` varchar(255) NOT NULL,
  `Phone` int(255) NOT NULL,
  `ID_No` int(255) NOT NULL,
  `PIN_No` varchar(255) NOT NULL,
  `NHIF_No` varchar(255) NOT NULL,
  `NHIF_Amount` decimal(25,2) NOT NULL,
  `NSSF_No` varchar(255) NOT NULL,
  `NSSF_Amount` decimal(25,2) NOT NULL,
  `Location` varchar(255) NOT NULL,
  `Date_Joined` date NOT NULL,
  `designation` varchar(255) NOT NULL,
  `department` varchar(255) NOT NULL,
  `Application_Letter` varchar(255) NOT NULL,
  `CV` varchar(255) NOT NULL,
  `Basic_Pay` decimal(25,2) NOT NULL,
  `Allowances` decimal(25,2) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=latin1;

INSERT INTO `employees` (`Employee_Id`, `Passport_Photo`, `Full_Name`, `Email`, `Phone`, `ID_No`, `PIN_No`, `NHIF_No`, `NHIF_Amount`, `NSSF_No`, `NSSF_Amount`, `Location`, `Date_Joined`, `designation`, `department`, `Application_Letter`, `CV`, `Basic_Pay`, `Allowances`, `id`) VALUES ('JORA002', '', 'RACHEAL MUTHAKYE KATENDE', 'rmuthakye@yahoo.com', '729656127', '13591677', 'A002891322M', '', '0.00', '', '0.00', '', '2008-09-11', 'Director', 'Administration', '', '', '0.00', '0.00', '21');
INSERT INTO `employees` (`Employee_Id`, `Passport_Photo`, `Full_Name`, `Email`, `Phone`, `ID_No`, `PIN_No`, `NHIF_No`, `NHIF_Amount`, `NSSF_No`, `NSSF_Amount`, `Location`, `Date_Joined`, `designation`, `department`, `Application_Letter`, `CV`, `Basic_Pay`, `Allowances`, `id`) VALUES ('JORA003', '', 'ABUBAKAR YUSUF MUSINGA', 'info@joralogisticsltd.co.ke', '726301600', '29519253', '', '', '0.00', '', '0.00', '', '2017-10-01', 'Port Clerk', 'Operations', '', '', '0.00', '0.00', '22');
INSERT INTO `employees` (`Employee_Id`, `Passport_Photo`, `Full_Name`, `Email`, `Phone`, `ID_No`, `PIN_No`, `NHIF_No`, `NHIF_Amount`, `NSSF_No`, `NSSF_Amount`, `Location`, `Date_Joined`, `designation`, `department`, `Application_Letter`, `CV`, `Basic_Pay`, `Allowances`, `id`) VALUES ('JORA004', '', 'FELIX WAMBUA KIOKO', 'info@joralogisticsltd.co.ke', '741498826', '35844451', 'A012389388N', '', '0.00', '', '0.00', '', '2018-09-10', 'Port Clerk', 'Operations', '', '', '0.00', '0.00', '23');
INSERT INTO `employees` (`Employee_Id`, `Passport_Photo`, `Full_Name`, `Email`, `Phone`, `ID_No`, `PIN_No`, `NHIF_No`, `NHIF_Amount`, `NSSF_No`, `NSSF_Amount`, `Location`, `Date_Joined`, `designation`, `department`, `Application_Letter`, `CV`, `Basic_Pay`, `Allowances`, `id`) VALUES ('JORA001', '', 'JOHN MUTEMI MUTAMBUKI', 'johnmutemim@yahoo.com', '722178521', '11652158', 'A001885131W', '', '0.00', '', '0.00', '', '2008-09-11', 'C.E.O/ Managing Director', 'Administration', '', '', '0.00', '0.00', '20');


#
# TABLE STRUCTURE FOR: expenditures
#

DROP TABLE IF EXISTS `expenditures`;

CREATE TABLE `expenditures` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `officeid` int(50) NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `vat` decimal(25,2) NOT NULL,
  `paidto` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `refno` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `description` text NOT NULL,
  `propertyid` varchar(50) NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `paidto` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `refno` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: exports
#

DROP TABLE IF EXISTS `exports`;

CREATE TABLE `exports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `shipping_line` varchar(255) NOT NULL,
  `container_no` varchar(255) NOT NULL,
  `bl_no` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `vehicle` varchar(255) NOT NULL,
  `client` varchar(255) NOT NULL,
  `from` varchar(255) NOT NULL,
  `to` varchar(255) NOT NULL,
  `container_size` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `exports` (`id`, `shipping_line`, `container_no`, `bl_no`, `date`, `vehicle`, `client`, `from`, `to`, `container_size`) VALUES ('1', 'MAESK', 'CONT 556', 'BL 84', '0000-00-00', 'KCR 546 T', 'ROMANIAN CHILDREN\'S MISSION', 'KENYA', 'CHINA', '20 FT');


#
# TABLE STRUCTURE FOR: groups
#

DROP TABLE IF EXISTS `groups`;

CREATE TABLE `groups` (
  `id` mediumint(8) unsigned NOT NULL,
  `name` varchar(20) NOT NULL,
  `description` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `groups` (`id`, `name`, `description`) VALUES ('1', 'members', 'General User');
INSERT INTO `groups` (`id`, `name`, `description`) VALUES ('1', 'members', 'General User');


#
# TABLE STRUCTURE FOR: imports
#

DROP TABLE IF EXISTS `imports`;

CREATE TABLE `imports` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `container_no` varchar(255) NOT NULL,
  `container_size` varchar(255) NOT NULL,
  `shipping_line` varchar(255) NOT NULL,
  `bl_no` varchar(255) NOT NULL,
  `date_in` date NOT NULL,
  `departuredate` date NOT NULL,
  `date_back` date NOT NULL,
  `from` varchar(255) NOT NULL,
  `to` varchar(255) NOT NULL,
  `client` varchar(255) NOT NULL,
  `vehicle` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `imports` (`id`, `container_no`, `container_size`, `shipping_line`, `bl_no`, `date_in`, `departuredate`, `date_back`, `from`, `to`, `client`, `vehicle`) VALUES ('1', 'MSCU 6941509', '20 FT', 'OCEANFREIGHT(EA) LTD\'', 'MEDUDC039424\'', '2018-11-03', '2018-11-03', '2018-11-18', 'UNITED ARAB EMIRATES', 'KENYA', 'MICHEAL AGABA', 'KBN 189 A');


#
# TABLE STRUCTURE FOR: invoiceitems
#

DROP TABLE IF EXISTS `invoiceitems`;

CREATE TABLE `invoiceitems` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `invoiceid` int(50) NOT NULL,
  `invoice_refno` varchar(100) NOT NULL,
  `item_name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

INSERT INTO `invoiceitems` (`id`, `invoiceid`, `invoice_refno`, `item_name`, `description`, `amount`) VALUES ('5', '38', '2019January1B5', 'Water Bill', 'Water bill', '1000.00');
INSERT INTO `invoiceitems` (`id`, `invoiceid`, `invoice_refno`, `item_name`, `description`, `amount`) VALUES ('6', '0', '2019January1B5', 'Water Bill', 'Water Consumption Bill', '1000.00');
INSERT INTO `invoiceitems` (`id`, `invoiceid`, `invoice_refno`, `item_name`, `description`, `amount`) VALUES ('7', '0', '2019January1B5', '', '', '11.00');
INSERT INTO `invoiceitems` (`id`, `invoiceid`, `invoice_refno`, `item_name`, `description`, `amount`) VALUES ('8', '0', '2019January1B5', 'Elec', 'KPLC Meter', '500.00');
INSERT INTO `invoiceitems` (`id`, `invoiceid`, `invoice_refno`, `item_name`, `description`, `amount`) VALUES ('9', '0', '2019January1B5', 'Late FIne', 'eklnlk', '200.00');
INSERT INTO `invoiceitems` (`id`, `invoiceid`, `invoice_refno`, `item_name`, `description`, `amount`) VALUES ('10', '39', '2019January1B5', 'water', 'water', '500.00');


#
# TABLE STRUCTURE FOR: invoicepayments
#

DROP TABLE IF EXISTS `invoicepayments`;

CREATE TABLE `invoicepayments` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `month` varchar(50) NOT NULL,
  `year` int(50) NOT NULL,
  `landlordid` int(11) DEFAULT NULL,
  `propertyid` int(11) DEFAULT NULL,
  `tenantid` int(11) DEFAULT NULL,
  `invoiceid` int(50) NOT NULL,
  `method` varchar(50) NOT NULL,
  `amount_paid` decimal(25,2) NOT NULL DEFAULT 0.00,
  `commission` decimal(25,2) DEFAULT 0.00,
  `vat` decimal(25,2) DEFAULT 0.00,
  `landlord_amount` decimal(25,2) DEFAULT 0.00,
  `refno` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(50) NOT NULL,
  `recordcreator` varchar(45) DEFAULT NULL,
  `recordcreated` timestamp NULL DEFAULT current_timestamp(),
  `reversaltime` int(100) NOT NULL,
  `reversalreason` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: invoices
#

DROP TABLE IF EXISTS `invoices`;

CREATE TABLE `invoices` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `property_id` varchar(50) NOT NULL,
  `unit_code` varchar(50) NOT NULL,
  `tenant_id` varchar(50) NOT NULL,
  `year` int(50) NOT NULL,
  `month` varchar(50) NOT NULL,
  `invoice_type` varchar(45) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `amount` decimal(25,2) NOT NULL,
  `paid` decimal(25,2) NOT NULL,
  `balance` decimal(25,2) NOT NULL,
  `status` varchar(50) NOT NULL,
  `refid` varchar(50) NOT NULL,
  `tax_status` varchar(45) DEFAULT NULL,
  `commisionable` varchar(45) DEFAULT NULL,
  `invoicedate` date DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: landlord
#

DROP TABLE IF EXISTS `landlord`;

CREATE TABLE `landlord` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(50) NOT NULL,
  `idno` int(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` int(50) NOT NULL,
  `postal` varchar(45) DEFAULT NULL,
  `bank` varchar(45) DEFAULT NULL,
  `branch` varchar(45) DEFAULT NULL,
  `account` varchar(45) DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `landlord` (`id`, `fullname`, `idno`, `email`, `phone`, `postal`, `bank`, `branch`, `account`, `record_creator`, `record_created`) VALUES ('1', 'Geo Mara Luxury Homes', '999999', 'Gmara476@Gmail.Com', '705669214', '5061-00100', 'Equity Bank', 'Kilimani', '012540', 'webmaster', '2021-01-11 15:05:31');


#
# TABLE STRUCTURE FOR: leaves
#

DROP TABLE IF EXISTS `leaves`;

CREATE TABLE `leaves` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `Leave_Title` varchar(255) NOT NULL,
  `Employee_Name` varchar(255) NOT NULL,
  `Employee_Id` varchar(255) NOT NULL,
  `emp` varchar(255) NOT NULL,
  `Phone` int(255) NOT NULL,
  `Email` varchar(255) NOT NULL,
  `Department` varchar(255) NOT NULL,
  `Designation` varchar(255) NOT NULL,
  `Start_Date` date NOT NULL,
  `End_Date` date NOT NULL,
  `Ref_Code` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1;

INSERT INTO `leaves` (`id`, `Leave_Title`, `Employee_Name`, `Employee_Id`, `emp`, `Phone`, `Email`, `Department`, `Designation`, `Start_Date`, `End_Date`, `Ref_Code`) VALUES ('35', 'Annual Leave', 'RACHEAL MUTHAKYE KATENDE', '', '', '0', '', 'Administration', 'Director', '2018-07-16', '2018-07-17', '');


#
# TABLE STRUCTURE FOR: loan_payment_reversals
#

DROP TABLE IF EXISTS `loan_payment_reversals`;

CREATE TABLE `loan_payment_reversals` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reversal_ref_code` varchar(255) NOT NULL,
  `payment_ref_code` varchar(255) NOT NULL,
  `loan_ref_code` varchar(255) NOT NULL,
  `loan_total_amount` decimal(25,2) NOT NULL,
  `loan_previous_balance` decimal(25,2) NOT NULL,
  `transaction_amount_paid` decimal(25,2) NOT NULL,
  `amount_reversed` decimal(25,2) NOT NULL,
  `loan_new_balance` decimal(25,2) NOT NULL,
  `posted_by` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('13', '2018-05-16', '1526465847', '1526465828', '', '11800.00', '6000.00', '5800.00', '2000.00', '8000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('14', '2018-05-16', '1526465999', '1526465828', '', '11800.00', '8000.00', '3800.00', '3800.00', '11800.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('15', '2018-05-16', '1526466266', '1526466103', '', '11800.00', '10000.00', '1800.00', '1000.00', '11000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('16', '2018-05-16', '1526466486', '1526466460', '', '11800.00', '1000.00', '10000.00', '5000.00', '6000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('17', '2018-05-16', '1526469605', '1526469461', '', '11800.00', '0.00', '6000.00', '3000.00', '3000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('18', '2018-05-16', '1526469695', '1526469461', '1526465812', '11800.00', '3000.00', '3000.00', '3000.00', '6000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('19', '2018-05-16', '1526488113', '1526488031', '1526487973', '1040.00', '500.00', '540.00', '40.00', '540.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('20', '2018-05-17', '1526577616', '1526574908', '1526573991', '118000.00', '100000.00', '18000.00', '18000.00', '118000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('21', '2018-05-17', '1526578013', '1526577943', '1526573991', '118000.00', '100000.00', '18000.00', '8000.00', '108000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('22', '2018-05-17', '1526578081', '1526574908', '1526573991', '118000.00', '118000.00', '0.00', '0.00', '118000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('23', '2018-05-17', '1526578136', '1526577943', '1526573991', '118000.00', '108000.00', '10000.00', '5000.00', '113000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('24', '2018-05-17', '1526578333', '1526578249', '1526573991', '118000.00', '110000.00', '3000.00', '3000.00', '113000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('25', '2018-05-17', '1526580332', '1526580261', '1526580066', '24336.00', '-30.00', '24366.00', '24000.00', '23970.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('26', '2018-05-17', '1526582785', '1526579560', '1526573991', '118000.00', '0.00', '113000.00', '100000.00', '100000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('27', '2018-05-17', '1526593849', '2147483647', '1526592961', '118000.00', '-7000.00', '5000.00', '5000.00', '-2000.00', 'webmaster');
INSERT INTO `loan_payment_reversals` (`id`, `date`, `reversal_ref_code`, `payment_ref_code`, `loan_ref_code`, `loan_total_amount`, `loan_previous_balance`, `transaction_amount_paid`, `amount_reversed`, `loan_new_balance`, `posted_by`) VALUES ('28', '2018-05-17', '1526593874', '2147483647', '1526592961', '118000.00', '-2000.00', '5000.00', '5000.00', '3000.00', 'webmaster');


#
# TABLE STRUCTURE FOR: loan_payments
#

DROP TABLE IF EXISTS `loan_payments`;

CREATE TABLE `loan_payments` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `payment_ref_code` int(255) NOT NULL,
  `loan_id` int(255) NOT NULL,
  `loan_ref_code` int(255) NOT NULL,
  `employee_id` varchar(255) NOT NULL,
  `full_name` varchar(255) NOT NULL,
  `loan_amount` decimal(25,2) NOT NULL,
  `paid` decimal(25,2) NOT NULL,
  `balance` decimal(25,2) NOT NULL,
  `amount_paid` decimal(25,2) NOT NULL,
  `payment_method` varchar(255) NOT NULL,
  `date` date NOT NULL,
  `posted_by` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: loan_types
#

DROP TABLE IF EXISTS `loan_types`;

CREATE TABLE `loan_types` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `interest` int(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `loan_types` (`id`, `name`, `interest`) VALUES ('1', 'Emergency Loan', '10');
INSERT INTO `loan_types` (`id`, `name`, `interest`) VALUES ('2', 'School Fees', '10');
INSERT INTO `loan_types` (`id`, `name`, `interest`) VALUES ('3', 'Mortgage Loan ', '10');
INSERT INTO `loan_types` (`id`, `name`, `interest`) VALUES ('5', 'Business Loan', '10');
INSERT INTO `loan_types` (`id`, `name`, `interest`) VALUES ('6', 'Co-Opera', '10');
INSERT INTO `loan_types` (`id`, `name`, `interest`) VALUES ('7', 'Car Loan', '10');


#
# TABLE STRUCTURE FOR: loans
#

DROP TABLE IF EXISTS `loans`;

CREATE TABLE `loans` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `Date` date NOT NULL,
  `loan_ref_code` int(255) NOT NULL,
  `employee_id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `loan_type` varchar(255) NOT NULL,
  `loan_amount` decimal(25,2) NOT NULL,
  `monthly_payment_amount` decimal(25,2) NOT NULL,
  `interest_amount` decimal(25,2) NOT NULL,
  `total_loan` decimal(25,2) NOT NULL,
  `paid` decimal(25,2) NOT NULL,
  `balance` decimal(25,2) NOT NULL,
  `status` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO `loans` (`id`, `Date`, `loan_ref_code`, `employee_id`, `name`, `loan_type`, `loan_amount`, `monthly_payment_amount`, `interest_amount`, `total_loan`, `paid`, `balance`, `status`) VALUES ('15', '2018-07-16', '1531771652', '34345', 'Test name', 'Emergency Loan', '5600.00', '700.00', '560.00', '6160.00', '0.00', '6160.00', 'Unpaid');


#
# TABLE STRUCTURE FOR: login_attempts
#

DROP TABLE IF EXISTS `login_attempts`;

CREATE TABLE `login_attempts` (
  `id` int(11) unsigned NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` int(11) unsigned DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

#
# TABLE STRUCTURE FOR: offices
#

DROP TABLE IF EXISTS `offices`;

CREATE TABLE `offices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(45) DEFAULT NULL,
  `name` varchar(45) DEFAULT NULL,
  `location` varchar(45) DEFAULT NULL,
  `postal_address` varchar(45) DEFAULT NULL,
  `phone_number` varchar(45) DEFAULT NULL,
  `alternate_phone_number` varchar(45) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `offices` (`id`, `type`, `name`, `location`, `postal_address`, `phone_number`, `alternate_phone_number`, `email`, `record_creator`, `record_created`) VALUES ('1', 'Head Office', 'Kiambiu Branch', 'Kiambiui', NULL, NULL, NULL, NULL, NULL, '2021-01-12 14:07:49');


#
# TABLE STRUCTURE FOR: payslips
#

DROP TABLE IF EXISTS `payslips`;

CREATE TABLE `payslips` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `Employee` varchar(255) NOT NULL,
  `emp` varchar(255) NOT NULL,
  `Full_Name` varchar(255) NOT NULL,
  `Basic_Pay` decimal(25,2) NOT NULL,
  `Allowances` decimal(25,2) NOT NULL,
  `Gross_Pay` decimal(25,2) NOT NULL,
  `ADVANCE` decimal(25,2) NOT NULL,
  `NSSF` decimal(25,2) NOT NULL,
  `NHIF` decimal(25,2) NOT NULL,
  `PAYE` decimal(25,2) NOT NULL,
  `Other_Deductions_Amount` decimal(25,2) NOT NULL,
  `Other_Deductions_Note` text NOT NULL,
  `Loan_Payment` decimal(25,2) NOT NULL,
  `Relief` decimal(25,2) NOT NULL,
  `Taxable_Pay` decimal(25,2) NOT NULL,
  `Less_Deductions` decimal(25,2) NOT NULL,
  `Nett_Pay` decimal(25,2) NOT NULL,
  `Month` varchar(255) NOT NULL,
  `Year` int(255) NOT NULL,
  `Date` date NOT NULL,
  `Ref_Code` varchar(255) NOT NULL,
  `paymentmethod` varchar(255) NOT NULL,
  `paymentref` varchar(255) NOT NULL,
  `Status` varchar(255) NOT NULL,
  `Posted_By` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=latin1;

INSERT INTO `payslips` (`id`, `Employee`, `emp`, `Full_Name`, `Basic_Pay`, `Allowances`, `Gross_Pay`, `ADVANCE`, `NSSF`, `NHIF`, `PAYE`, `Other_Deductions_Amount`, `Other_Deductions_Note`, `Loan_Payment`, `Relief`, `Taxable_Pay`, `Less_Deductions`, `Nett_Pay`, `Month`, `Year`, `Date`, `Ref_Code`, `paymentmethod`, `paymentref`, `Status`, `Posted_By`) VALUES ('9', '23', 'JORA004', 'FELIX WAMBUA KIOKO', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', 'JANUARY', '2019', '2018-12-05', 'JORA004JANUARY2019', 'Mobile Money', '', 'Pending', 'joramanagement.co.ke');
INSERT INTO `payslips` (`id`, `Employee`, `emp`, `Full_Name`, `Basic_Pay`, `Allowances`, `Gross_Pay`, `ADVANCE`, `NSSF`, `NHIF`, `PAYE`, `Other_Deductions_Amount`, `Other_Deductions_Note`, `Loan_Payment`, `Relief`, `Taxable_Pay`, `Less_Deductions`, `Nett_Pay`, `Month`, `Year`, `Date`, `Ref_Code`, `paymentmethod`, `paymentref`, `Status`, `Posted_By`) VALUES ('7', '20', 'JORA001', 'JOHN MUTEMI MUTAMBUKI', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', 'JANUARY', '2019', '2018-12-04', 'JORA001NOVEMBER2018', 'Mobile Money', '', 'Pending', 'webmaster');
INSERT INTO `payslips` (`id`, `Employee`, `emp`, `Full_Name`, `Basic_Pay`, `Allowances`, `Gross_Pay`, `ADVANCE`, `NSSF`, `NHIF`, `PAYE`, `Other_Deductions_Amount`, `Other_Deductions_Note`, `Loan_Payment`, `Relief`, `Taxable_Pay`, `Less_Deductions`, `Nett_Pay`, `Month`, `Year`, `Date`, `Ref_Code`, `paymentmethod`, `paymentref`, `Status`, `Posted_By`) VALUES ('8', '22', 'JORA003', 'ABUBAKAR YUSUF MUSINGA', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', 'JANUARY', '2019', '2018-12-05', 'JORA003JANUARY2019', 'Mobile Money', '', 'Pending', 'joramanagement.co.ke');
INSERT INTO `payslips` (`id`, `Employee`, `emp`, `Full_Name`, `Basic_Pay`, `Allowances`, `Gross_Pay`, `ADVANCE`, `NSSF`, `NHIF`, `PAYE`, `Other_Deductions_Amount`, `Other_Deductions_Note`, `Loan_Payment`, `Relief`, `Taxable_Pay`, `Less_Deductions`, `Nett_Pay`, `Month`, `Year`, `Date`, `Ref_Code`, `paymentmethod`, `paymentref`, `Status`, `Posted_By`) VALUES ('6', '21', 'JORA002', 'RACHEAL MUTHAKYE KATENDE', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '0.00', '', '0.00', '0.00', '0.00', '0.00', '0.00', 'JANUARY', '2019', '2018-12-04', 'JORA002JANUARY2010', 'Mobile Money', '', 'Pending', 'webmaster');


#
# TABLE STRUCTURE FOR: property
#

DROP TABLE IF EXISTS `property`;

CREATE TABLE `property` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `landlord_id` int(11) NOT NULL,
  `branch_id` int(11) DEFAULT NULL,
  `property_name` varchar(50) DEFAULT NULL,
  `property_type` varchar(45) DEFAULT NULL,
  `location` varchar(50) DEFAULT NULL,
  `commission` int(50) DEFAULT NULL,
  `electricity_deposit` decimal(25,2) DEFAULT NULL,
  `water_deposit` decimal(25,2) DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`,`landlord_id`),
  UNIQUE KEY `id_UNIQUE` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO `property` (`id`, `landlord_id`, `branch_id`, `property_name`, `property_type`, `location`, `commission`, `electricity_deposit`, `water_deposit`, `record_creator`, `record_created`) VALUES ('1', '1', '1', 'PLOT 162', 'Apartment', 'Kiambiu', '0', '0.00', '0.00', 'webmaster', '2021-01-11 15:07:43');
INSERT INTO `property` (`id`, `landlord_id`, `branch_id`, `property_name`, `property_type`, `location`, `commission`, `electricity_deposit`, `water_deposit`, `record_creator`, `record_created`) VALUES ('2', '1', '1', 'PLOT 57', 'Apartment', 'Kiambiu', '0', '0.00', '0.00', 'webmaster', '2021-01-11 16:22:08');
INSERT INTO `property` (`id`, `landlord_id`, `branch_id`, `property_name`, `property_type`, `location`, `commission`, `electricity_deposit`, `water_deposit`, `record_creator`, `record_created`) VALUES ('3', '1', '1', 'PLOT 97', 'Apartment', 'Kiambiu', '0', '0.00', '0.00', 'webmaster', '2021-01-11 16:36:23');
INSERT INTO `property` (`id`, `landlord_id`, `branch_id`, `property_name`, `property_type`, `location`, `commission`, `electricity_deposit`, `water_deposit`, `record_creator`, `record_created`) VALUES ('4', '1', '1', 'GeoMara Marcus Garden', 'Apartment', 'Kiambiu', '0', '0.00', '0.00', 'webmaster', '2021-01-23 08:10:20');
INSERT INTO `property` (`id`, `landlord_id`, `branch_id`, `property_name`, `property_type`, `location`, `commission`, `electricity_deposit`, `water_deposit`, `record_creator`, `record_created`) VALUES ('5', '1', '1', 'GeoMara Junction Suites', 'Apartment', 'Kiambiu', '0', '0.00', '0.00', 'webmaster', '2021-01-23 08:10:20');
INSERT INTO `property` (`id`, `landlord_id`, `branch_id`, `property_name`, `property_type`, `location`, `commission`, `electricity_deposit`, `water_deposit`, `record_creator`, `record_created`) VALUES ('6', '1', '1', 'GeoMara Thompson Glade', 'Apartment', 'Kiambiu', '0', '0.00', '0.00', 'webmaster', '2021-01-23 08:10:20');
INSERT INTO `property` (`id`, `landlord_id`, `branch_id`, `property_name`, `property_type`, `location`, `commission`, `electricity_deposit`, `water_deposit`, `record_creator`, `record_created`) VALUES ('7', '1', '1', 'GeoMara Miotoni Heights', 'Apartment', 'Kiambiu', '0', '0.00', '0.00', 'webmaster', '2021-01-23 08:10:20');


#
# TABLE STRUCTURE FOR: propertytypes
#

DROP TABLE IF EXISTS `propertytypes`;

CREATE TABLE `propertytypes` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO `propertytypes` (`id`, `name`, `description`) VALUES ('1', 'Apartments', 'Apartments building');
INSERT INTO `propertytypes` (`id`, `name`, `description`) VALUES ('2', 'Bungalow ', 'Bungalows');


#
# TABLE STRUCTURE FOR: roles
#

DROP TABLE IF EXISTS `roles`;

CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `display_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `roles` (`id`, `name`, `display_name`, `created_at`, `updated_at`) VALUES ('1', 'admin', 'Administrator', '2019-02-10 05:27:32', '2019-02-10 05:27:32');
INSERT INTO `roles` (`id`, `name`, `display_name`, `created_at`, `updated_at`) VALUES ('2', 'user', 'Normal User', '2019-02-10 05:27:32', '2019-02-10 05:27:32');


#
# TABLE STRUCTURE FOR: settings
#

DROP TABLE IF EXISTS `settings`;

CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sms_status` varchar(45) DEFAULT NULL,
  `tenant_notification` varchar(45) DEFAULT NULL,
  `landlord_notification` varchar(45) DEFAULT NULL,
  `staff_notification` varchar(45) DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO `settings` (`id`, `sms_status`, `tenant_notification`, `landlord_notification`, `staff_notification`, `record_creator`, `record_created`) VALUES ('1', 'Enabled', 'Enabled', 'Enabled', 'Enabled', 'webmaster', '2019-03-02 01:46:17');
INSERT INTO `settings` (`id`, `sms_status`, `tenant_notification`, `landlord_notification`, `staff_notification`, `record_creator`, `record_created`) VALUES ('2', NULL, 'Disabled', 'Disabled', NULL, 'webmaster', '2019-03-02 02:00:00');
INSERT INTO `settings` (`id`, `sms_status`, `tenant_notification`, `landlord_notification`, `staff_notification`, `record_creator`, `record_created`) VALUES ('3', NULL, NULL, NULL, NULL, 'webmaster', '2019-03-02 03:51:07');


#
# TABLE STRUCTURE FOR: sms
#

DROP TABLE IF EXISTS `sms`;

CREATE TABLE `sms` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `phone` int(255) NOT NULL,
  `message` text NOT NULL,
  `time` datetime NOT NULL,
  `cost` decimal(25,2) NOT NULL,
  `status` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: stream_performance_summary
#

DROP TABLE IF EXISTS `stream_performance_summary`;

CREATE TABLE `stream_performance_summary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` varchar(45) DEFAULT NULL,
  `form` varchar(45) DEFAULT NULL,
  `stream` varchar(45) DEFAULT NULL,
  `term` varchar(45) DEFAULT NULL,
  `subject` varchar(45) DEFAULT NULL,
  `a_con` int(11) DEFAULT NULL,
  `a_minus` int(11) DEFAULT NULL,
  `b_plus` int(11) DEFAULT NULL,
  `b_con` int(11) DEFAULT NULL,
  `b_minus` int(11) DEFAULT NULL,
  `c_plus` int(11) DEFAULT NULL,
  `c_con` int(11) DEFAULT NULL,
  `c_minus` int(11) DEFAULT NULL,
  `d_plus` int(11) DEFAULT NULL,
  `d_con` int(11) DEFAULT NULL,
  `d_minus` int(11) DEFAULT NULL,
  `e` int(11) DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8;

INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('1', '2018', 'Form 2', 'E', 'Term 3', 'English', '0', '0', '0', '0', '0', '1', '1', '0', '1', '2', '2', '53', 'Kyalie', '2018-11-15 04:00:49');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('2', '2018', 'Form 2', 'E', 'Term 3', 'Kiswahili', '0', '0', '0', '1', '0', '1', '1', '1', '3', '10', '6', '37', 'Kyalie', '2018-11-15 04:00:49');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('3', '2018', 'Form 2', 'E', 'Term 3', 'Mathematics', '3', '0', '1', '1', '8', '0', '11', '3', '4', '0', '3', '26', 'Kyalie', '2018-11-15 04:00:50');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('4', '2018', 'Form 2', 'E', 'Term 3', 'Biology', '0', '0', '0', '1', '1', '3', '5', '0', '0', '1', '1', '48', 'Kyalie', '2018-11-15 04:00:50');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('5', '2018', 'Form 2', 'E', 'Term 3', 'Physics', '3', '0', '0', '3', '2', '0', '1', '0', '0', '0', '0', '51', 'Kyalie', '2018-11-15 04:00:50');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('6', '2018', 'Form 2', 'E', 'Term 3', 'Chemistry', '11', '0', '5', '11', '8', '0', '4', '0', '1', '0', '2', '17', 'Kyalie', '2018-11-15 04:00:50');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('7', '2018', 'Form 2', 'E', 'Term 3', 'History', '1', '0', '2', '0', '2', '1', '1', '0', '0', '0', '0', '53', 'Kyalie', '2018-11-15 04:00:51');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('8', '2018', 'Form 2', 'E', 'Term 3', 'Geography', '3', '0', '3', '1', '1', '0', '0', '0', '0', '0', '0', '49', 'Kyalie', '2018-11-15 04:00:51');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('9', '2018', 'Form 2', 'E', 'Term 3', 'CRE', '7', '0', '1', '0', '0', '0', '2', '1', '0', '0', '0', '48', 'Kyalie', '2018-11-15 04:00:51');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('10', '2018', 'Form 2', 'E', 'Term 3', 'Agriculture', '0', '0', '3', '7', '8', '15', '9', '4', '2', '0', '1', '11', 'Kyalie', '2018-11-15 04:00:51');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('11', '2018', 'Form 2', 'E', 'Term 3', 'Computer Studies', '1', '0', '0', '1', '1', '0', '3', '0', '2', '0', '0', '52', 'Kyalie', '2018-11-15 04:00:51');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('12', '2018', 'Form 2', 'E', 'Term 3', 'Business Studies', '24', '7', '3', '7', '5', '0', '1', '1', '0', '0', '0', '12', 'Kyalie', '2018-11-15 04:00:52');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('13', '2018', 'Form 2', 'W', 'Term 3', 'English', '5', '0', '5', '0', '2', '2', '8', '1', '6', '0', '18', '14', 'Kyalie', '2018-11-15 04:00:52');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('14', '2018', 'Form 2', 'W', 'Term 3', 'Kiswahili', '1', '1', '0', '0', '1', '0', '1', '0', '0', '0', '0', '57', 'Kyalie', '2018-11-15 04:00:52');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('15', '2018', 'Form 2', 'W', 'Term 3', 'Mathematics', '6', '0', '0', '2', '3', '0', '1', '0', '0', '2', '1', '46', 'Kyalie', '2018-11-15 04:00:52');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('16', '2018', 'Form 2', 'W', 'Term 3', 'Biology', '0', '0', '0', '0', '0', '1', '2', '0', '0', '0', '0', '58', 'Kyalie', '2018-11-15 04:00:52');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('17', '2018', 'Form 2', 'W', 'Term 3', 'Physics', '5', '0', '2', '0', '0', '0', '3', '3', '1', '1', '0', '46', 'Kyalie', '2018-11-15 04:00:52');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('18', '2018', 'Form 2', 'W', 'Term 3', 'Chemistry', '4', '0', '0', '4', '2', '0', '2', '3', '4', '0', '2', '40', 'Kyalie', '2018-11-15 04:00:52');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('19', '2018', 'Form 2', 'W', 'Term 3', 'History', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '60', 'Kyalie', '2018-11-15 04:00:53');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('20', '2018', 'Form 2', 'W', 'Term 3', 'Geography', '0', '1', '7', '1', '16', '3', '7', '0', '0', '0', '0', '26', 'Kyalie', '2018-11-15 04:00:53');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('21', '2018', 'Form 2', 'W', 'Term 3', 'CRE', '2', '0', '1', '3', '3', '1', '2', '5', '6', '4', '2', '32', 'Kyalie', '2018-11-15 04:00:53');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('22', '2018', 'Form 2', 'W', 'Term 3', 'Agriculture', '1', '1', '2', '2', '2', '2', '6', '7', '4', '2', '0', '32', 'Kyalie', '2018-11-15 04:00:53');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('23', '2018', 'Form 2', 'W', 'Term 3', 'Computer Studies', '1', '0', '0', '0', '0', '3', '0', '2', '0', '4', '4', '47', 'Kyalie', '2018-11-15 04:00:53');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('24', '2018', 'Form 2', 'W', 'Term 3', 'Business Studies', '1', '6', '12', '4', '11', '0', '0', '1', '0', '0', '0', '26', 'Kyalie', '2018-11-15 04:00:53');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('25', '2018', 'Form 3', 'E', 'Term 3', 'English', '0', '0', '0', '0', '0', '0', '0', '1', '2', '0', '2', '21', 'Kyalie', '2018-11-15 04:00:54');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('26', '2018', 'Form 3', 'E', 'Term 3', 'Kiswahili', '3', '0', '0', '2', '0', '0', '4', '0', '0', '0', '4', '13', 'Kyalie', '2018-11-15 04:00:54');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('27', '2018', 'Form 3', 'E', 'Term 3', 'Mathematics', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '26', 'Kyalie', '2018-11-15 04:00:54');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('28', '2018', 'Form 3', 'E', 'Term 3', 'Biology', '3', '0', '0', '1', '2', '0', '3', '9', '0', '0', '1', '1', 'Kyalie', '2018-11-15 04:00:54');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('29', '2018', 'Form 3', 'E', 'Term 3', 'Physics', '0', '0', '0', '0', '0', '0', '0', '1', '1', '0', '2', '0', 'Kyalie', '2018-11-15 04:00:54');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('30', '2018', 'Form 3', 'E', 'Term 3', 'Chemistry', '1', '0', '0', '0', '2', '0', '2', '2', '3', '0', '4', '12', 'Kyalie', '2018-11-15 04:00:54');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('31', '2018', 'Form 3', 'E', 'Term 3', 'History', '0', '1', '0', '0', '1', '0', '0', '1', '0', '1', '0', '3', 'Kyalie', '2018-11-15 04:00:55');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('32', '2018', 'Form 3', 'E', 'Term 3', 'Geography', '2', '0', '0', '1', '0', '0', '0', '0', '0', '0', '0', '2', 'Kyalie', '2018-11-15 04:00:55');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('33', '2018', 'Form 3', 'E', 'Term 3', 'CRE', '3', '0', '0', '9', '2', '0', '0', '0', '2', '0', '3', '6', 'Kyalie', '2018-11-15 04:00:55');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('34', '2018', 'Form 3', 'E', 'Term 3', 'Agriculture', '0', '1', '1', '2', '0', '1', '0', '0', '3', '0', '0', '4', 'Kyalie', '2018-11-15 04:00:55');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('35', '2018', 'Form 3', 'E', 'Term 3', 'Business Studies', '0', '0', '1', '0', '2', '0', '3', '0', '1', '0', '1', '0', 'Kyalie', '2018-11-15 04:00:55');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('36', '2018', 'Form 3', 'W', 'Term 3', 'English', '2', '5', '6', '4', '5', '7', '7', '3', '1', '2', '6', '11', 'Kyalie', '2018-11-15 04:00:55');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('37', '2018', 'Form 3', 'W', 'Term 3', 'Kiswahili', '2', '0', '0', '0', '1', '1', '1', '3', '4', '0', '2', '45', 'Kyalie', '2018-11-15 04:00:55');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('38', '2018', 'Form 3', 'W', 'Term 3', 'Mathematics', '0', '0', '0', '0', '0', '1', '1', '2', '1', '4', '2', '48', 'Kyalie', '2018-11-15 04:00:56');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('39', '2018', 'Form 3', 'W', 'Term 3', 'Biology', '1', '0', '0', '1', '0', '0', '2', '1', '1', '0', '1', '34', 'Kyalie', '2018-11-15 04:00:56');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('40', '2018', 'Form 3', 'W', 'Term 3', 'Physics', '0', '0', '0', '1', '0', '0', '0', '0', '4', '1', '0', '2', 'Kyalie', '2018-11-15 04:00:56');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('41', '2018', 'Form 3', 'W', 'Term 3', 'Chemistry', '1', '0', '0', '1', '0', '0', '2', '1', '1', '0', '7', '46', 'Kyalie', '2018-11-15 04:00:56');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('42', '2018', 'Form 3', 'W', 'Term 3', 'History', '0', '0', '0', '1', '2', '0', '3', '2', '4', '1', '5', '24', 'Kyalie', '2018-11-15 04:00:56');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('43', '2018', 'Form 3', 'W', 'Term 3', 'Geography', '0', '0', '0', '1', '0', '0', '0', '0', '0', '0', '0', '0', 'Kyalie', '2018-11-15 04:00:56');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('44', '2018', 'Form 3', 'W', 'Term 3', 'CRE', '0', '0', '0', '1', '0', '0', '0', '2', '0', '3', '1', '13', 'Kyalie', '2018-11-15 04:00:56');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('45', '2018', 'Form 3', 'W', 'Term 3', 'Agriculture', '0', '0', '2', '2', '1', '0', '1', '3', '0', '1', '0', '10', 'Kyalie', '2018-11-15 04:00:57');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('46', '2018', 'Form 3', 'W', 'Term 3', 'Business Studies', '0', '1', '0', '1', '2', '0', '1', '0', '1', '0', '0', '0', 'Kyalie', '2018-11-15 04:00:57');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('47', '2018', 'Form 4', 'E', 'Term 3', 'English', '0', '0', '0', '0', '0', '1', '2', '1', '1', '0', '0', '13', 'Kyalie', '2018-11-15 04:00:57');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('48', '2018', 'Form 4', 'E', 'Term 3', 'Kiswahili', '5', '0', '0', '1', '0', '0', '1', '0', '2', '0', '1', '8', 'Kyalie', '2018-11-15 04:00:57');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('49', '2018', 'Form 4', 'E', 'Term 3', 'Mathematics', '2', '0', '0', '0', '1', '0', '0', '0', '2', '0', '2', '11', 'Kyalie', '2018-11-15 04:00:58');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('50', '2018', 'Form 4', 'E', 'Term 3', 'Biology', '0', '0', '0', '1', '1', '0', '5', '1', '2', '0', '0', '3', 'Kyalie', '2018-11-15 04:00:58');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('51', '2018', 'Form 4', 'E', 'Term 3', 'Physics', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '3', 'Kyalie', '2018-11-15 04:00:58');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('52', '2018', 'Form 4', 'E', 'Term 3', 'Chemistry', '0', '0', '0', '0', '1', '0', '2', '1', '1', '0', '1', '7', 'Kyalie', '2018-11-15 04:00:58');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('53', '2018', 'Form 4', 'E', 'Term 3', 'History', '1', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '5', 'Kyalie', '2018-11-15 04:00:58');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('54', '2018', 'Form 4', 'E', 'Term 3', 'Geography', '1', '0', '0', '0', '1', '0', '0', '0', '1', '0', '0', '0', 'Kyalie', '2018-11-15 04:00:58');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('55', '2018', 'Form 4', 'E', 'Term 3', 'CRE', '6', '0', '0', '0', '1', '0', '1', '0', '0', '0', '0', '0', 'Kyalie', '2018-11-15 04:00:58');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('56', '2018', 'Form 4', 'E', 'Term 3', 'Agriculture', '0', '0', '0', '0', '1', '0', '0', '1', '0', '0', '0', '1', 'Kyalie', '2018-11-15 04:00:58');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('57', '2018', 'Form 4', 'E', 'Term 3', 'Business Studies', '0', '0', '0', '0', '1', '1', '3', '0', '1', '0', '1', '0', 'Kyalie', '2018-11-15 04:00:59');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('58', '2018', 'Form 4', 'W', 'Term 3', 'English', '0', '0', '0', '0', '0', '1', '0', '0', '0', '2', '0', '30', 'Kyalie', '2018-11-15 04:00:59');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('59', '2018', 'Form 4', 'W', 'Term 3', 'Kiswahili', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '13', 'Kyalie', '2018-11-15 04:00:59');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('60', '2018', 'Form 4', 'W', 'Term 3', 'Mathematics', '0', '0', '0', '0', '0', '1', '0', '1', '0', '1', '7', '23', 'Kyalie', '2018-11-15 04:00:59');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('61', '2018', 'Form 4', 'W', 'Term 3', 'Biology', '1', '0', '1', '1', '0', '0', '3', '3', '6', '0', '1', '8', 'Kyalie', '2018-11-15 04:00:59');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('62', '2018', 'Form 4', 'W', 'Term 3', 'Physics', '0', '0', '0', '0', '0', '0', '1', '0', '1', '1', '2', '5', 'Kyalie', '2018-11-15 04:00:59');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('63', '2018', 'Form 4', 'W', 'Term 3', 'Chemistry', '1', '0', '1', '0', '2', '0', '0', '2', '2', '0', '1', '13', 'Kyalie', '2018-11-15 04:01:00');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('64', '2018', 'Form 4', 'W', 'Term 3', 'History', '0', '0', '0', '0', '0', '0', '0', '2', '0', '0', '0', '0', 'Kyalie', '2018-11-15 04:01:00');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('65', '2018', 'Form 4', 'W', 'Term 3', 'Geography', '5', '0', '0', '2', '1', '0', '0', '0', '1', '0', '1', '0', 'Kyalie', '2018-11-15 04:01:00');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('66', '2018', 'Form 4', 'W', 'Term 3', 'CRE', '4', '0', '0', '1', '0', '0', '0', '1', '3', '0', '0', '1', 'Kyalie', '2018-11-15 04:01:00');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('67', '2018', 'Form 4', 'W', 'Term 3', 'Agriculture', '0', '2', '0', '3', '0', '0', '0', '1', '0', '0', '0', '1', 'Kyalie', '2018-11-15 04:01:00');
INSERT INTO `stream_performance_summary` (`id`, `year`, `form`, `stream`, `term`, `subject`, `a_con`, `a_minus`, `b_plus`, `b_con`, `b_minus`, `c_plus`, `c_con`, `c_minus`, `d_plus`, `d_con`, `d_minus`, `e`, `record_creator`, `record_created`) VALUES ('68', '2018', 'Form 4', 'W', 'Term 3', 'Computer Studies', '0', '0', '0', '0', '0', '0', '0', '0', '1', '0', '0', '2', 'Kyalie', '2018-11-15 04:01:00');


#
# TABLE STRUCTURE FOR: subscription
#

DROP TABLE IF EXISTS `subscription`;

CREATE TABLE `subscription` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `ref` varchar(45) DEFAULT NULL,
  `property_id` varchar(50) NOT NULL,
  `unit_code` varchar(50) NOT NULL,
  `unit_id` varchar(45) DEFAULT NULL,
  `tenant_id` varchar(50) NOT NULL,
  `date` date DEFAULT NULL,
  `rent` decimal(25,2) NOT NULL,
  `rent_deposit` decimal(25,2) NOT NULL,
  `water_deposit` decimal(25,2) NOT NULL,
  `electricity_deposit` decimal(25,2) NOT NULL,
  `status` varchar(50) NOT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  `rentdepo_refund` decimal(25,2) NOT NULL,
  `waterdepo_refund` decimal(25,2) NOT NULL,
  `elecdepo_refund` decimal(25,2) NOT NULL,
  `vacate_comments` text NOT NULL,
  `terminate_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: tax
#

DROP TABLE IF EXISTS `tax`;

CREATE TABLE `tax` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_agency` varchar(45) DEFAULT NULL,
  `pin` varchar(45) DEFAULT NULL,
  `rate` decimal(25,2) DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO `tax` (`id`, `tax_agency`, `pin`, `rate`, `status`, `record_creator`, `record_created`) VALUES ('1', 'Kenya Revenue Authority', 'A00678IIEWE23', '16.00', 'Enabled', 'webmaster', '2019-03-01 22:49:47');


#
# TABLE STRUCTURE FOR: tenants
#

DROP TABLE IF EXISTS `tenants`;

CREATE TABLE `tenants` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `property_id` varchar(45) DEFAULT NULL,
  `unit_id` varchar(45) DEFAULT NULL,
  `unit_code` varchar(45) DEFAULT NULL,
  `idno` varchar(50) NOT NULL,
  `fullname` varchar(50) NOT NULL,
  `phone` int(50) NOT NULL,
  `email` varchar(50) NOT NULL,
  `status` varchar(45) DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: trips
#

DROP TABLE IF EXISTS `trips`;

CREATE TABLE `trips` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `client` varchar(255) NOT NULL,
  `vehicle` varchar(255) NOT NULL,
  `driver` varchar(255) NOT NULL,
  `tripfrom` varchar(255) NOT NULL,
  `tripto` varchar(255) NOT NULL,
  `departure` datetime NOT NULL,
  `arrival` datetime NOT NULL,
  `delivery` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO `trips` (`id`, `date`, `client`, `vehicle`, `driver`, `tripfrom`, `tripto`, `departure`, `arrival`, `delivery`) VALUES ('1', '2018-09-13', 'AXION LOGISTICS LTD', 'KBG 436 U', 'MARY JANE', 'Mombasa', 'Nairobi', '2018-09-12 00:00:00', '2018-09-20 00:00:00', 'ON-BOARD');
INSERT INTO `trips` (`id`, `date`, `client`, `vehicle`, `driver`, `tripfrom`, `tripto`, `departure`, `arrival`, `delivery`) VALUES ('2', '2018-09-11', 'AXION LOGISTICS LTD', 'KBB 789K', 'James Mwangi', 'Kissi', 'Nairobi', '2018-09-14 00:00:00', '2018-09-20 00:00:00', 'COMPLETED');
INSERT INTO `trips` (`id`, `date`, `client`, `vehicle`, `driver`, `tripfrom`, `tripto`, `departure`, `arrival`, `delivery`) VALUES ('4', '2018-09-07', 'AXION LOGISTICS LTD', 'KBS 897 Y', 'James Mwangi', 'Mombasa', 'Masabu', '2018-09-14 00:00:00', '2018-09-21 00:00:00', 'ON-BOARD');
INSERT INTO `trips` (`id`, `date`, `client`, `vehicle`, `driver`, `tripfrom`, `tripto`, `departure`, `arrival`, `delivery`) VALUES ('6', '2018-09-11', 'AXION LOGISTICS LTD', 'KBG 436 U', 'JOYCE WAMAITO', 'Mombasa', 'Kisumu', '2018-09-13 00:00:00', '2018-09-14 00:00:00', 'PENDING');


#
# TABLE STRUCTURE FOR: units
#

DROP TABLE IF EXISTS `units`;

CREATE TABLE `units` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `landlord_id` int(11) DEFAULT NULL,
  `property_id` int(11) DEFAULT NULL,
  `property_name` varchar(255) DEFAULT NULL,
  `unit_code` varchar(50) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `rent` decimal(25,2) DEFAULT NULL,
  `rent_deposit` decimal(25,2) DEFAULT NULL,
  `electricity_deposit` decimal(25,2) DEFAULT NULL,
  `water_deposit` decimal(25,2) DEFAULT NULL,
  `status` varchar(45) DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_UNIQUE` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO `units` (`id`, `landlord_id`, `property_id`, `property_name`, `unit_code`, `type`, `rent`, `rent_deposit`, `electricity_deposit`, `water_deposit`, `status`, `record_creator`, `record_created`) VALUES ('1', '1', '1', 'PLOT', 'S1', 'Shops', '6000.00', '8500.00', '1.00', '1.00', 'Occupied', 'webmaster', '2021-01-11 16:33:10');
INSERT INTO `units` (`id`, `landlord_id`, `property_id`, `property_name`, `unit_code`, `type`, `rent`, `rent_deposit`, `electricity_deposit`, `water_deposit`, `status`, `record_creator`, `record_created`) VALUES ('2', '1', '1', 'PLOT', 'S2', 'Shops', '6000.00', '8500.00', '1.00', '1.00', 'Vacant', 'webmaster', '2021-01-11 16:33:10');


#
# TABLE STRUCTURE FOR: unittypes
#

DROP TABLE IF EXISTS `unittypes`;

CREATE TABLE `unittypes` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1;

INSERT INTO `unittypes` (`id`, `name`, `description`) VALUES ('1', 'Bedsitter', 'Single room self contained');
INSERT INTO `unittypes` (`id`, `name`, `description`) VALUES ('2', 'One Bedroom', '2 rooms self contained with kitchen area');
INSERT INTO `unittypes` (`id`, `name`, `description`) VALUES ('3', 'Single Room', 'rooms');
INSERT INTO `unittypes` (`id`, `name`, `description`) VALUES ('4', 'Two Bedroom', 'rooms');
INSERT INTO `unittypes` (`id`, `name`, `description`) VALUES ('5', 'Three Bedroom', 'rooms');
INSERT INTO `unittypes` (`id`, `name`, `description`) VALUES ('6', 'Four Bedroom', 'rooms');
INSERT INTO `unittypes` (`id`, `name`, `description`) VALUES ('7', 'Five Bedroom', 'rooms');
INSERT INTO `unittypes` (`id`, `name`, `description`) VALUES ('8', 'Shops', 'rooms');


#
# TABLE STRUCTURE FOR: user
#

DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

#
# TABLE STRUCTURE FOR: users
#

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `id` int(11) unsigned NOT NULL,
  `ip_address` varchar(15) NOT NULL,
  `username` varchar(100) DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `salt` varchar(255) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `activation_code` varchar(40) DEFAULT NULL,
  `forgotten_password_code` varchar(40) DEFAULT NULL,
  `forgotten_password_time` int(11) unsigned DEFAULT NULL,
  `remember_code` varchar(40) DEFAULT NULL,
  `created_on` int(11) unsigned NOT NULL,
  `last_login` int(11) unsigned DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `about` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `users` (`id`, `ip_address`, `username`, `password`, `salt`, `email`, `activation_code`, `forgotten_password_code`, `forgotten_password_time`, `remember_code`, `created_on`, `last_login`, `active`, `first_name`, `last_name`, `company`, `phone`, `about`) VALUES ('1', '127.0.0.1', 'member', '$2y$08$lt6NJDrDleLxJ/DHUPj8UecQuL4J9jZlOaE2g1BUT9ymU4bq0Zxtu', NULL, 'member@member.com', NULL, NULL, NULL, NULL, '1451903855', '1451905011', '1', 'Member', 'One', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: users_groups
#

DROP TABLE IF EXISTS `users_groups`;

CREATE TABLE `users_groups` (
  `id` int(11) unsigned NOT NULL,
  `user_id` int(11) unsigned NOT NULL,
  `group_id` mediumint(8) unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `users_groups` (`id`, `user_id`, `group_id`) VALUES ('1', '1', '1');


#
# TABLE STRUCTURE FOR: utilitybillpayments
#

DROP TABLE IF EXISTS `utilitybillpayments`;

CREATE TABLE `utilitybillpayments` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `utilitybill_id` int(100) NOT NULL,
  `propertyid` int(100) NOT NULL,
  `tenantid` int(100) NOT NULL,
  `date` date NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `method` varchar(200) NOT NULL,
  `refno` varchar(200) NOT NULL,
  `status` varchar(200) NOT NULL,
  `record_creator` varchar(100) NOT NULL,
  `reversaltime` datetime NOT NULL,
  `reversalreason` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `utilitybillpayments` (`id`, `utilitybill_id`, `propertyid`, `tenantid`, `date`, `amount`, `method`, `refno`, `status`, `record_creator`, `reversaltime`, `reversalreason`) VALUES ('1', '1', '2', '2', '2019-04-30', '1500.00', 'CASH', 'DE34G5423', 'Paid', 'webmaster', '0000-00-00 00:00:00', '');


#
# TABLE STRUCTURE FOR: utilitybills
#

DROP TABLE IF EXISTS `utilitybills`;

CREATE TABLE `utilitybills` (
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `property_id` varchar(50) NOT NULL,
  `unit_code` varchar(50) NOT NULL,
  `tenant_id` varchar(50) NOT NULL,
  `year` int(50) NOT NULL,
  `month` varchar(50) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `amount` decimal(25,2) NOT NULL,
  `paid` decimal(25,2) NOT NULL,
  `balance` decimal(25,2) NOT NULL,
  `status` varchar(50) NOT NULL,
  `refno` varchar(50) NOT NULL,
  `date` date DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `utilitybills` (`id`, `property_id`, `unit_code`, `tenant_id`, `year`, `month`, `name`, `description`, `amount`, `paid`, `balance`, `status`, `refno`, `date`, `record_creator`, `record_created`) VALUES ('1', '2', 'F1', '2', '2019', 'January', 'Water bill for April', 'Water Bill', '2000.00', '1500.00', '500.00', 'Partial', '2019January2F1', '2019-04-30', NULL, '2019-04-30 19:07:31');


#
# TABLE STRUCTURE FOR: vehicles
#

DROP TABLE IF EXISTS `vehicles`;

CREATE TABLE `vehicles` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `plateno` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO `vehicles` (`id`, `plateno`, `type`, `description`) VALUES ('1', 'KBS 897 Y', 'TRAILER', 'MERCEDES  TRAILER ');
INSERT INTO `vehicles` (`id`, `plateno`, `type`, `description`) VALUES ('2', 'KBG 436 U', 'TRAILER', '234 TONNES 10 WHEELS');
INSERT INTO `vehicles` (`id`, `plateno`, `type`, `description`) VALUES ('3', 'KAA 789P', 'PICK UPP', 'ISUZU  D MAX 900 TONNES');
INSERT INTO `vehicles` (`id`, `plateno`, `type`, `description`) VALUES ('4', 'KBB 789K', 'PROBOX', 'TOYOYA PROBOX SAFE GUARD ESCORT');
INSERT INTO `vehicles` (`id`, `plateno`, `type`, `description`) VALUES ('5', 'KBD230', 'Lorry', 'fully loaded');


#
# TABLE STRUCTURE FOR: voucherpayments
#

DROP TABLE IF EXISTS `voucherpayments`;

CREATE TABLE `voucherpayments` (
  `voucherid` varchar(50) NOT NULL,
  `date` date NOT NULL,
  `amount` decimal(25,2) NOT NULL,
  `method` varchar(50) NOT NULL,
  `refno` varchar(50) NOT NULL,
  `landlordid` varchar(50) NOT NULL,
  `propertyid` varchar(50) NOT NULL,
  `id` int(50) NOT NULL AUTO_INCREMENT,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO `voucherpayments` (`voucherid`, `date`, `amount`, `method`, `refno`, `landlordid`, `propertyid`, `id`, `record_creator`, `record_created`) VALUES ('4', '2019-04-30', '16550.00', 'CASH', '2019April21', '1', '2', '1', 'webmaster', '2019-04-30 19:09:45');


#
# TABLE STRUCTURE FOR: vouchers
#

DROP TABLE IF EXISTS `vouchers`;

CREATE TABLE `vouchers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `landlord_id` int(11) DEFAULT NULL,
  `property_id` int(11) DEFAULT NULL,
  `property` varchar(45) DEFAULT NULL,
  `year` int(11) DEFAULT NULL,
  `month` varchar(45) DEFAULT NULL,
  `amount` decimal(25,2) DEFAULT NULL,
  `refid` varchar(100) DEFAULT NULL,
  `paid` decimal(25,2) DEFAULT NULL,
  `balance` decimal(25,2) DEFAULT NULL,
  `voucherscol` int(11) NOT NULL,
  `voucherdate` date NOT NULL,
  `status` varchar(45) DEFAULT NULL,
  `record_creator` varchar(45) DEFAULT NULL,
  `record_created` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

INSERT INTO `vouchers` (`id`, `landlord_id`, `property_id`, `property`, `year`, `month`, `amount`, `refid`, `paid`, `balance`, `voucherscol`, `voucherdate`, `status`, `record_creator`, `record_created`) VALUES ('1', '1', '1', NULL, '2019', 'January', NULL, '2019January11', '0.00', NULL, '0', '2019-04-30', 'Due', NULL, '2019-04-30 19:08:57');
INSERT INTO `vouchers` (`id`, `landlord_id`, `property_id`, `property`, `year`, `month`, `amount`, `refid`, `paid`, `balance`, `voucherscol`, `voucherdate`, `status`, `record_creator`, `record_created`) VALUES ('2', '1', '2', NULL, '2019', 'January', NULL, '2019January21', '0.00', NULL, '0', '2019-04-30', 'Due', NULL, '2019-04-30 19:08:57');
INSERT INTO `vouchers` (`id`, `landlord_id`, `property_id`, `property`, `year`, `month`, `amount`, `refid`, `paid`, `balance`, `voucherscol`, `voucherdate`, `status`, `record_creator`, `record_created`) VALUES ('3', '1', '1', NULL, '2019', 'April', NULL, '2019April11', '0.00', NULL, '0', '2019-04-30', 'Due', NULL, '2019-04-30 19:09:16');
INSERT INTO `vouchers` (`id`, `landlord_id`, `property_id`, `property`, `year`, `month`, `amount`, `refid`, `paid`, `balance`, `voucherscol`, `voucherdate`, `status`, `record_creator`, `record_created`) VALUES ('4', '1', '2', NULL, '2019', 'April', '16550.00', '2019April21', '16550.00', '0.00', '0', '2019-04-30', 'Paid', NULL, '2019-04-30 19:09:16');


