<?php

  
    class MYPDF extends TCPDF {
        
   
    
}
// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Joel Mwas');
$pdf->SetTitle('Property Report');
$pdf->SetSubject(' ');
$pdf->SetKeywords('');
$pdf->SetTextColor(0,0,0);
// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('helveticaB', '', 12);

// set cell padding
$pdf->setCellPaddings(1, 1, 1, 1);

// set cell margins
$pdf->setCellMargins(1, 1, 1, 1);

// add a page
 $pdf->AddPage("L");

$query = $this->db->get_where('property', array('id'=>$id));
$pname = $query->row('property_name');
$lid = $query->row('landlord_id');
$ptype = $query->row('property_type');
$plocation = $query->row('location');

$query = $this->db->get_where('landlord', array('id'=>$lid));
$lname = $query->row('fullname');
$lphone = $query->row('phone');
$lemail = $query->row('email');




$html = <<<EOF
<div style="text-align:center; "><h2><u>PROPERTY REPORT</u></h2></div>

EOF;

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');
// -----------------------------------------------------------------------------


 
$tbl_header = '
<table style="font-size: 11px;" cellspacing="" cellpadding="2" border="0.1"     >
 

<tr style="background-color:#fcfcfc">
     <th><b>PROPERTY NAME</b></th>
     <th><b>LOCATION</b></th> 
     <th><b>LANDLORD NAME</b></th>
     <th><b>PHONE</b></th>
     <th><b>EMAIL</b></th>
 
 </tr>

';

$tbl_footer = '</table>';

$tbl = '';


      
      
    $tbl .= '
     <tr>
            <td style="border: 1px solid #000000; ">'.$pname.'</td>
            <td style="border: 1px solid #000000; ">'.$plocation.'</td>
            <td style="border: 1px solid #000000; ">'.$lname.'</td>
            <td style="border: 1px solid #000000; ">0'.$lphone.'</td>
            <td style="border: 1px solid #000000; ">'.$lemail.'</td>
           
      
    </tr>
    
';      

 

$pdf->writeHTML($tbl_header . $tbl . $tbl_footer, true, false, false, false, ''); 


 

 
$tbl_header = '
<table style="font-size: 11px;" cellspacing="" cellpadding="2" border="0.1"     >
<P>UNITS DETAILS </P>

<tr style="background-color:#fcfcfc">
     <th><b>TYPE</b></th>
     <th><b>UNIT CODE</b></th> 
     <th><b>TENANT</b></th>
     <th><b>PHONE</b></th>
     <th><b>ID NO</b></th>
     <th><b>RENT</b></th>
      <th><b>STATUS</b></th>
 </tr>

';

$tbl_footer = '</table>';

$tbl = '';

   $query = $this->db->get_where('units', array('property_id'=> $id));
   foreach ($query->result() as $row)    {
       
       if($row->status == "Occupied"){
          $query = $this->db->get_where('tenants', array('unit_code'=>$row->unit_code, 'property_id'=>$id));
          $name = $query->row('fullname');
          $phone = $query->row('phone');
          $idno = $query->row('idno');
          
          
       }
      
      
    $tbl .= '
     <tr>
            <td style="border: 1px solid #000000; ">'.$row->type.'</td>
            <td style="border: 1px solid #000000; ">'.$row->unit_code.'</td>
            <td style="border: 1px solid #000000; ">'.$name.'</td>
            <td style="border: 1px solid #000000; ">0'.$phone.'</td>
            <td style="border: 1px solid #000000; ">'.$idno.'</td>
            <td style="border: 1px solid #000000; ">'.number_format($row->rent,2).'</td>
             <td style="border: 1px solid #000000; ">'.$row->status.'</td>
      
    </tr>
    
';      

}

$pdf->writeHTML($tbl_header . $tbl . $tbl_footer, true, false, false, false, ''); 




 
// -----------------------------------------------------------------------------


// -----------------------------------------------------------------------------

 

// -----------------------------------------------------------------------------
$tbl = <<<EOD

<table cellspacing="0" cellpadding="0" border="0">
   
<tr>
<td width="450px;"> <i>Authorised Signature: _______________________________________ </i> </td>

</tr>

</table>


EOD;


$pdf->writeHTML($tbl, true, false, false, false, '');

// -----------------------------------------------------------------------------

$html = '

';
$pdf->writeHTML($html, true, false, true, false, '');

// -----------------------------------------------------------------------------

 

//Close and output PDF document
$pdf->Output('Property Statement Report.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
  
  