<?php

if (!defined('BASEPATH')) exit('No direct script access allowed');

class Settings_model extends CI_Model {

    var $offices = 'offices';
    var $settings = 'settings';
    var $tax = 'tax';

    public function _construct() {
        parent::__construct();
        $this->load->database();
    }

    public function insert_office($data) {
        $this->db->insert($this->offices, $data);
        return $this->insert_id();
    }

    public function update_office($where, $data) {
        $this->db->update($this->offices, $data, $where);
        return $this->db->affected_rows();
    }

    public function get_office_by_id($id) {
        $this->db->from($this->offices);
        $this->db->where('id', $id);
        $query = $this->db->get();
        return $query->row();
    }

    public function get_all_offices() {
        $this->db->from('offices');
        $query = $this->db->get();
        return $query->results();
    }

    public function add_sms_settings($data) {
        $this->db->insert($this->settings, $data);
        return $this->insert_id();
    }

    public function update_sm_settings($where, $data) {
        $this->db->update($this - settings, $data, $where);
        return $this->db->affected_rows;
    }

    public function get_sms_settings() {
        $this->db->from('settings');
        $query = $this->db->get();
        return $query->results;
    }

    public function set_tax($data) {
        $this->db->insert($this->tax, $data);
        return $this->insert_id();
    }

    public function update_tax($where, $data) {
        $this->db->update($this->tax, $data, $where);
        return $this->db->affected_rows;
    }

    public function get_tax_settings() {
        $this->db->from('tax');
        $query = $this->db->get();
        return $query->results;
    }

}
