<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Consultation extends Admin_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->library('excel');
        $this->load->model('patients_model');
        $this->load->model('queue_model');
        $this->load->model('diagnosis_model');
        $this->load->model('consultation_model');
        $this->load->model('tests_model');
        $this->load->model('laboratory_model');
        $this->load->model('triage_model');
        $this->load->model('prescription_model');
    }

    public function index()
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['triage'] = $this->queue_model->get_by_department('Consultation');
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "Access Consultation") !== false) {
            $this->render('Consultation/index');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function diagnosis()
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['diagnosis'] = $this->diagnosis_model->get_all();
        $this->render('Consultation/diagnosis');
    }

    public function add_diagnosis()
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        //$this->mViewData['diagnosis'] = $this->diagnosis_model->gset_all();
        $this->render('Consultation/add_diagnosis');
    }

    public function view_diagnosis($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['diagnosis'] = $this->diagnosis_model->get_by_id($id);
        $this->render('Consultation/view_diagnosis');
    }

    public function edit_diagnosis($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['diagnosis'] = $this->diagnosis_model->get_by_id($id);
        $this->render('Consultation/edit_diagnosis');
    }

    public function search()
    {
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $id = $user->id;
        $date = explode('-', $this->input->post('daterange'));
        $startdate = str_replace('/', '-', str_replace(" ", "", $date[0]));
        $enddate = str_replace('/', '-', str_replace(" ", "", $date[1]));
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $id));
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        $rights = $sql->row('rights');
        $this->mViewData['rights'] = $rights;
        // if (strpos($sql->row('rights'), "Access Own Records") !== false) {
        //     $this->db->where('record_creator', $username);
        //     $this->db->where('date >=', $startdate);
        //     $this->db->where('date <=', $enddate);
        //     $sql = $this->db->get('consultation');
        //     $response = $sql->result();
        // } else {
            $this->db->where('date >=', $startdate);
            $this->db->where('date <=', $enddate);
            $sql = $this->db->get('consultation');
            $response = $sql->result();
        // }
        $this->mViewData['records'] = $response;
        $this->render('Consultation/list');
    }

    public function add($qid, $vid)
    {
        $date = date('Y-m-d');
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['queue'] = $this->queue_model->get_by_id($qid);
        $this->mViewData['triage'] = $this->triage_model->get_by_visitId($vid);
        $this->mViewData['diagnosis'] = $this->diagnosis_model->get_all();
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "Add Clinical Examination") !== false) {
            $this->render('Consultation/add');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function list()
    {
        $date = date('Y-m-d');
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $username = $user->username;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        $rights = $sql->row('rights');
        $this->mViewData['rights'] = $rights;
        //if (strpos($sql->row('rights'), "Access Own Records") !== false) {
            //$this->mViewData['records'] = $this->consultation_model->get_by_owner($username);
        ///} else {
            $this->mViewData['records'] = $this->consultation_model->get_by_date($date);
        //}
        if (strpos($sql->row('rights'), "Access Consultation") !== false) {
            $this->render('Consultation/list');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function records()
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['records'] = $this->consultation_model->get_all();
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "Access Consultation") !== false) {
            $this->render('Consultation/list');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function results()
    {
        $date = date('Y-m-d');
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['records'] = $this->laboratory_model->get_by_date($date);
        $this->render('Consultation/results');
    }

    public function prescribe($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['record'] = $this->laboratory_model->get_by_id($id);
        $this->render('Consultation/prescription');
    }

    public function edit($v_id)
    {
        $date = date('Y-m-d');
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $this->mViewData['v_id'] = $v_id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['records'] = $this->consultation_model->get_by_visitId($v_id);
        $this->mViewData['triage'] = $this->triage_model->get_by_visitId($v_id);
        $this->mViewData['diagnosis'] = $this->diagnosis_model->get_all();
        $this->mViewData['laboratory'] = $this->laboratory_model->get_by_visitId($v_id);
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "Edit Clinical Record") !== false) {
            $this->render('Consultation/edit');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function view($id, $pid, $date)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['records'] = $this->consultation_model->get_by_id($id);
        $this->mViewData['triage'] = $this->triage_model->select_patient($pid);
        $this->mViewData['prescription'] = $this->prescription_model->get_by_id_d($pid, $date);
        $this->mViewData['diagnosis'] = $this->diagnosis_model->get_all();
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "View Patient Medical History") !== false) {
            $this->render('Consultation/view');
        } else {
            $this->render('errors/custom/access');
        }
    }

    public function finalize($id, $qid)
    {
        $date = date('Y-m-d');
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['v_id'] = $id;
        $this->mViewData['records'] = $this->consultation_model->get_by_visitId($id);
        $this->mViewData['triage'] = $this->triage_model->get_by_visitId($id);
        $this->mViewData['diagnosis'] = $this->diagnosis_model->get_all();
        $this->mViewData['laboratory'] = $this->laboratory_model->get_by_visitId($id);
        $data = array(
            'status' => 'Attended',
        );
        $this->db->where('id', $qid);
        $this->db->update('queues', $data);
        $this->render('Consultation/edit');
    }

    public function queue($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['patient'] = $this->patients_model->get_by_id($id);
        $this->mViewData['tests'] = $this->tests_model->get_all();
        $this->render('Consultation/queue');
    }

    public function save_diagnosis()
    {
        //Logged In User Session
        $user = $this->ion_auth->user()->row();
        $username = $user->username;

        $data = array(
            'diagnosis' => $this->input->post('diagnosis'),
            'causes' => $this->input->post('causes'),
            'signs' => $this->input->post('signs'),
            'treatment' => $this->input->post('treatment'),
            'record_creator' => $username,
        );

        $res = $this->diagnosis_model->save($data);
        if ($res == true) {
            redirect('admin/consultation/diagnosis');
        } else {
            $this->session->set_flashdata('error', "Record Not Inserted");
        }
    }

    public function update_diagnosis()
    {
        //Logged In User Session
        $user = $this->ion_auth->user()->row();
        $username = $user->username;

        $data = array(
            'diagnosis' => $this->input->post('diagnosis'),
            'causes' => $this->input->post('causes'),
            'signs' => $this->input->post('signs'),
            'treatment' => $this->input->post('treatment'),
        );

        $this->db->where('id', $this->input->post('id'));
        $res = $this->db->update('diagnosis', $data);
        if ($res == true) {
            redirect('admin/consultation/diagnosis');
        } else {
            $this->session->set_flashdata('error', "Record Not Inserted");
        }
    }

    public function save()
    {
        //Logged In User Session
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $q_id = $this->input->post("q_id");
        $date = date('Y-m-d');

        $patient_id = $this->input->post('patient_id');
        $presenting_symptoms = $this->input->post('presenting_symptoms');
        $clinical_notes = $this->input->post('clinical_notes');
        $general_examination = $this->input->post('general_examination');
        $systemic_examination = $this->input->post('systemic_examination');
        $past_medical_history = $this->input->post('past_medical_history');
        $diagnosis = "";
        if (isset($_POST['diagnosis'])) {
            $diagnosis = ltrim(implode($_POST['diagnosis'], ";"), ";");
        }
        $prescription = $this->input->post('prescription');
        $action = $this->input->post('action');

        $sql = $this->db->get_where('visits', array('patient_id' => $patient_id, 'date' => $date));
        $visit_id = $sql->row('visit_id');

        $data = array(
            'patient_id' => $patient_id,
            'visit_id' => $visit_id,
            'date' => $date,
            'signs_symptoms' => $presenting_symptoms,
            'clinical_notes' => $clinical_notes,
            'general_examination' => $general_examination,
            'systemic_examination' => $systemic_examination,
            'medical_history' => $past_medical_history,
            'diagnosis' => $diagnosis,
            'record_creator' => $username,
        );

        //Save Data
        $res = $this->consultation_model->save($data);
        if ($res == true) {
            if ($prescription == " ") {
                //
            } else {
                $data = array(
                    'visit_id' => $visit_id,
                    'patient_id' => $patient_id,
                    'date' => $date,
                    'prescription' => $prescription,
                    'prescribed_by' => $username,
                    'status' => 'Waiting',
                );

                $this->db->insert('prescription', $data);
            }

            //Update Q
            $data = array(
                'status' => 'Attended',
            );
            $this->db->where('id', $q_id);
            $this->db->update('queues', $data);
            $this->session->set_flashdata('success', "Record added Successfully");
            if ($action == 'queue') {
                redirect('admin/consultation/queue/' . $patient_id);
            } else {
                redirect('admin/consultation/list');
            }
        } else {
            $this->session->set_flashdata('error', "Record Not Inserted");
            redirect('admin/consultation/list');
        }
    }

    public function additional_notes()
    {
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $v_id = $this->input->post('v_id');
        $p_id = $this->input->post('p_id');
        $notes = $this->input->post('notes');

        $data = array(
            'additional_notes' => $notes,
            'additional_notes_by' => $username,
        );
        $this->db->where('visit_id', $v_id);
        $res = $this->db->update('consultation', $data);
        redirect('admin/patients/medical_history/' . $v_id . '/' . $p_id);
    }

    public function update()
    {
        //Logged In User Session
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $id = $this->input->post('id');
        $pid = $this->input->post('pres_id');
        $p_id = $this->input->post('patient_id');
        $date = date('Y-m-d');

        $presenting_symptoms = $this->input->post('presenting_symptoms');
        $clinical_notes = $this->input->post('clinical_notes');
        $general_examination = $this->input->post('general_examination');
        $systemic_examination = $this->input->post('systemic_examination');
        $past_medical_history = $this->input->post('past_medical_history');
        if (isset($_POST['diagnosis'])) {
            $diagnosis = ltrim(implode($_POST['diagnosis'], ';'), ";");
        }
        $prescription = $this->input->post('prescription');
        $action = $this->input->post('action');
        //Get visit ID
        $sql = $this->db->get_where('visits', array('patient_id' => $p_id, 'date' => $date));
        $visit_id = $sql->row('visit_id');

        //POST Data
        $data = array(
            'signs_symptoms' => $presenting_symptoms,
            'clinical_notes' => $clinical_notes,
            'general_examination' => $general_examination,
            'systemic_examination' => $systemic_examination,
            'medical_history' => $past_medical_history,
            'diagnosis' => $diagnosis,
        );

        //Save Data
        $this->db->where('id', $id);
        $res = $this->db->update('consultation', $data);
        if ($res == true) {
            if ($prescription == "") {
                //
            } else {
                $data = array(
                    'visit_id' => $visit_id,
                    'patient_id' => $p_id,
                    'date' => $date,
                    'prescription' => $prescription,
                    'prescribed_by' => $username,
                    'status' => 'Waiting',
                );
                $this->db->insert('prescription', $data);
            }

            $this->session->set_flashdata('success', "Record added Successfully");
            redirect('admin/consultation/list');
        } else {
            $this->session->set_flashdata('error', "Record Not Inserted");
            redirect('admin/consultation/list');
        }
    }

    public function prescription()
    {
        //Logged In User Session
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $id = $this->input->post("id");
        $data = array(
            'prescription' => $this->input->post('prescription'),
        );
        $this->db->where('id', $id);
        $res = $this->db->update('laboratory', $data);
        if ($res == true) {
            $this->session->set_flashdata('success', "Record added Successfully");
            redirect('admin/consultation/list');
        } else {
            $this->session->set_flashdata('error', "Record Not Inserted");
            redirect('admin/consultation/list');
        }
    }

    public function delete_record($id)
    {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $group_id = $query->row('group_id');
        $sql = $this->db->get_where('admin_groups', array('id' => $group_id));
        if (strpos($sql->row('rights'), "Delete Clinical Record") !== false) {
            $this->consultation_model->delete_by_id($id);
            echo json_encode(array("status" => TRUE));
        } else {
            echo json_encode(array("status" => FALSE));
        }
    }
}
