<?php

    $yr =  date('Y');
    $mnth =  date('m');
    
    class MYPDF extends TCPDF {
        
    // Page footer
    public function Footer() {
        // Position at 15 mm from bottom
        $this->SetY(-15);
        // Set font
        $this->SetFont('times', 'I', 10);
        // Page number
        $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'C', 0, '', 0, false, 'T', 'M');
    }
}

// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Joel Mwas');
$pdf->SetTitle('Expense Report');
$pdf->SetSubject('');
$pdf->SetKeywords('');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('times', '', 11);

// set cell padding
$pdf->setCellPaddings(1, 1, 1, 1);

// set cell margins
$pdf->setCellMargins(1, 1, 1, 1);

// add a page
$pdf->AddPage();


// -----------------------------------------------------------------------------

$html = '<div style="text-align:center; "><h2>EXPENSES REPORT </h2>
  <br>

<h3> From Date : <b>' .$start. ' </b> To Date :<b>' .$end. '</b> </h3>
</div>';
$pdf->writeHTML($html, true, false, true, false, '');


$html = '<hr>';
$pdf->writeHTML($html, true, false, true, false, '');



// -----------------------------------------------------------------------------

$tbl_header = '
<table cellpadding="1" border="0.1" style="text-align:center;" >

<p><b>EXPENSES RECORDS PROPERTY: '.$ppname.'</b> </p>

<tr cellpadding="2" border="1" style="text-align:center; font-size:10px; ">

    <th> <b>PROPERTY </b></th>
    <th> <b>DATE </b></th>
    <th> <b>TYPE </b></th> 
    <th> <b>DESCRIPTION </b></th>  
    <th> <b>AMOUNT </b></th> 
    <th> <b>PAID TO</b></th> 
    <th> <b>REF NO</b></th>
    
</tr>

';
$tbl_footer = '</table>';
$tbl = '';
$this->db->order_by("date", "asc");



 if ($property =='ALL') {
 $query1 = $this->db->get_where('expenses', array('date >=' => $start, 'date <=' => $end)); 
}
else {

   $query1 = $this->db->get_where('expenses', array('date >=' => $start, 'date <=' => $end, 'propertyid'=>$property));
}
// foreach item in your array...
  foreach ($query1->result() as $row)    {

    $query = $this->db->get_where('property', array('id'=>$row->propertyid ));

   foreach($query->result() as $pp){
    $ppname = $pp->property_name;
   }
      

      
$tbl .= '
 <tr>        
        <td style="border: 1px solid #000000; ">'.$ppname.'</td>
        <td style="border: 1px solid #000000; ">'.$row->date.'</td>
        <td style="border: 1px solid #000000; ">'.$row->type.'</td>
        <td style="border: 1px solid #000000; ">'.$row->description.'</td>
        <td style="border: 1px solid #000000; ">'.number_format($row->amount,2).'</td>
        <td style="border: 1px solid #000000; ">'.$row->paidto.'</td>
        <td style="border: 1px solid #000000; ">'.$row->refno.'</td>
  
 

</tr>
    
';
     

}

$pdf->writeHTML($tbl_header . $tbl . $tbl_footer, true, false, false, false, '');


$tbl = <<<EOD
<table cellspacing="0" cellpadding="1" border="0"  rowspan="7" style=" text-align:center;">
    <tr>
    <th></th>
    <th></th>
    <th></th>
      <th style=" background-color: #C4C6C4 "><b>TOTAL AMOUNT</b><br> <b> Ksh $total </b> </th>
    <th></th>
  

    </tr>
 
 
</table>
EOD;

$pdf->writeHTML($tbl, true, false, false, false, '');

// -----------------------------------------------------------------------------




$html = '<i><br>Authorised Signature ....................................................................................................................................</i></div>';
$pdf->writeHTML($html, true, false, true, false, '');



//Close and output PDF document
$pdf->Output('Expense Report.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
  
  