<div class="container">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-user"></i> Landlords
        </h1>
    </section>
    <section class="content padding-5">
        <div class="row">
            <div class="col-xs-12 text-right">
                <div class="form-group">
                    <a class="btn btn-primary" href="landlords/add"><i class="fa fa-plus"></i> Add landlord </a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    <div class="box-body table-responsive no-padding">
                        <table id="example2" class="table table-striped table-bordered" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>NAME</th>
                                    <th>ID NUMBER</th>
                                    <th>PHONE</th>
                                    <th>Address</th>
                                    <th>Bank</th>
                                    <th>Branch</th>
                                    <th>Account</th>
                                    <th style="width:125px;">Action</th
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($landlords as $landlord) { ?>
                                    <tr>
                                        <td><?php echo $landlord->id; ?></td>
                                        <td><?php echo $landlord->fullname; ?> </td>
                                        <td><?php echo $landlord->idno; ?> </td>
                                        <td><?php echo $landlord->phone; ?> </td>
                                        <td><?php echo $landlord->postal; ?> </td>
                                        <td><?php echo $landlord->bank; ?></td>
                                        <td><?php echo $landlord->branch; ?></td>
                                        <td><?php echo $landlord->account; ?></td>
                                        <td>

                                            <?php if ($usergroup == 1 || $usergroup == 2) { ?>

                                                <button class="btn btn-success" onclick="edit_landlord(<?php echo $landlord->id; ?>)"><i class="glyphicon  fa fa-pencil">Edit</i></button>
                                                <a  class="btn btn-primary" href="<?php echo base_url(); ?>admin/landlords/view_landlord/<?php echo $landlord->id; ?> "> 
                                                    <i class="glyphicon  fa fa-eye"></i></a>

                                            <?php } else { ?>

                                        <a  class="btn btn-primary" href="<?php echo base_url(); ?>admin/landlords/view_landlord/<?php echo $landlord->id; ?> "> 
                                                    <i class="glyphicon  glyphicon-eye-open"></i></a>
                                                    
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>

                            <tfoot>
                                <tr>
                                </tr>
                            </tfoot>
                        </table>

                    </div><!-- /.box-body -->
                </div><!-- /.box -->
            </div>
        </div>
    </section>
</div>


<script>
    function isNumber(evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    }
</script>
<script>
    function toTitleCase(str) {
        return str.replace(/\w*/g, function (txt) {
            return txt.charAt().toUpperCase() + txt.substr(1).toLowerCase();
        });
    }
</script>
<script>
    $(document).ready(function () {
        $("input[type='text']").blur(function () {
            var str = toTitleCase($(this).val());
            str = str.replace(/\s+/g, " ");
            str = str.replace(/(^\s+|\s+$)/g, "");
            $(this).val(str);
        });
    });
</script>
<script type="text/javascript">
    $(document).ready(function () {
        $('#table_id').DataTable();
    });
    var save_method; //for save method string
    var table;


    function add_landlord()
    {
        save_method = 'add';
        $('#form')[0].reset(); // reset form on modals
        $('#modal_form').modal('show'); // show bootstrap modal
        //$('.modal-title').text('Add Person'); // Set Title to Bootstrap modal title
    }

    function edit_landlord(id)
    {
        save_method = 'update';
        $('#form')[0].reset(); // reset form on modals

        //Ajax Load data from ajax
        $.ajax({
            url: "<?php echo site_url('admin/landlords/ajax_edit/') ?>/" + id,
            type: "GET",
            dataType: "JSON",
            success: function (data)
            {

                $('[name="fullname"]').val(data.fullname);
                $('[name="idno"]').val(data.idno);
                $('[name="address"]').val(data.postal);
                $('[name="phone"]').val(data.phone);
                $('[name="email"]').val(data.email);
                $('[name="bank"]').val(data.bank);
                $('[name="branch"]').val(data.branch);
                $('[name="account"]').val(data.account);
                $('[name="id"]').val(data.id);

                $('#modal_form').modal('show'); // show bootstrap modal when complete loaded
                $('.modal-title').text('Edit landlord'); // Set title to Bootstrap modal title

            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error get data from ajax');
            }
        });
    }

    function save()
    {
        var url;
        if (save_method == 'add')
        {
            url = "<?php echo base_url('admin/landlords/landlord_add') ?>";
        } else
        {
            url = "<?php echo site_url('admin/landlords/landlord_update') ?>";
        }

        // ajax adding data to database
        $.ajax({
            url: url,
            type: "POST",
            data: $('#form').serialize(),
            dataType: "JSON",
            success: function (data)
            {
                //if success close modal and reload ajax table
                $('#modal_form').modal('hide');
                location.reload();// for reload a page
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error adding / update data');
            }
        });
    }

    function delete_landlord(id)
    {
        if (confirm('Are you sure delete this data?'))
        {
            // ajax delete data from database
            $.ajax({
                url: "<?php echo site_url('admin/landlords/landlord_delete') ?>/" + id,
                type: "POST",
                dataType: "JSON",
                success: function (data)
                {

                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert('Error deleting data');
                }
            });

        }
    }

</script>
<script>
  
  $(document).ready(function() {
    $('#example2').DataTable( {
        dom: 'Bfrtip',
        buttons: [
            'copyHtml5',
            'excelHtml5',
            'csvHtml5',
            'pdfHtml5'
        ]
    } );
} );
</script>
<!-- Bootstrap modal -->
<div class="modal fade " id="modal_form" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h3 class="modal-title">Add New landlord</h3>
            </div>
            <div class="modal-body form">
                <form action="#" id="form" class="form-horizontal">
                    <input type="hidden" value="" name="id"/>

                    <div class="form-body">

                        <div class="form-group">
                            <label class="control-label col-md-3">Full Name*</label><br>
                            <div class="col-md-9">
                                <input name="fullname"  class="form-control" type="text" required>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3" >Id Number*</label><br>
                            <div class="col-md-9">
                                <input name="idno" onkeypress="return isNumber(event)"  class="form-control" type="text" required>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Phone Number*</label><br>
                            <div class="col-md-9">
                                <input name="phone" onkeypress="return isNumber(event)"  class="form-control" type="text" required>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Email Address</label><br>
                            <div class="col-md-9">
                                <input name="email"  class="form-control" type="text">

                            </div>
                        </div> 
                        <div class="form-group">
                            <label class="control-label col-md-3">Postal Address</label><br>
                            <div class="col-md-9">
                                <input name="address"  class="form-control" type="text">
                            </div>
                        </div> 
                        <div class="form-group">
                            <label class="control-label col-md-3">Bank Name</label><br>
                            <div class="col-md-9">
                                <input name="bank"  class="form-control" type="text">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Branch</label><br>
                            <div class="col-md-9">
                                <input name="branch"  class="form-control" type="text">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Account</label><br>
                            <div class="col-md-9">
                                <input name="account" onkeypress="return isNumber(event)"  class="form-control" type="text">
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" id="btnSave" onclick="save()" class="btn btn-primary">Save</button>
                            <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                        </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- End Bootstrap modal -->
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"></script>

