<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Vouchers extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('vouchers_model');
    }

    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');

        $this->mViewData['vouchers'] = $this->vouchers_model->get_all_vouchers();
        $this->render('_layouts/voucher');
    }

    public function details($id) {

        $this->mViewData['voucherid'] = $id;
        // $this->render('_layouts/voucherdetails');

        echo $id;
    }

    public function payments() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');

        $this->mViewData['payments'] = $this->vouchers_model->get_all_voucherpayments();
        $this->render('_layouts/voucherpayments');
    }

    public function paymentreverse() {

        $this->mViewData['primarykey'] = $this->input->post('id');
        $this->mViewData['invno'] = $this->input->post('invno');
        $this->mViewData['paid'] = $this->input->post('paid');
        $this->mViewData['method'] = $this->input->post('method');
        $this->render('_layouts/voucherpaymentreverse');
    }

    public function addpaymentreverse() {

        $id = $this->input->post('id');
        $invno = $this->input->post('invno');
        $paidreverse = $this->input->post('paid');
        $method = $this->input->post('method');

        $query = $this->db->get_where('vouchers', array('id' => $invno));
        $amountpaid = $query->row('paid');
        $amountbal = $query->row('balance');
        $newbal = $amountbal + $paidreverse;
        $newpaid = $amountpaid - $paidreverse;


        $data = array(
            'paid' => $newpaid,
            'balance' => $newbal,
        );

        $this->db->where('id', $invno);
        $this->db->update('vouchers', $data);



        $data2 = array(
            'status' => 'REVERSED',
            'reversaltime' => date('Y-m-d H:i:s'),
            'reversalreason' => $this->input->post('reason'),
        );

        $this->db->where('id', $id);
        $this->db->update('voucherpayment', $data2);
        redirect('admin/vouchers');
    }

 public function voucher_add() {

    $month = $this->input->post('month');
    $year = $this->input->post('year');

        $query = $this->db->get('property');

             foreach ($query->result() as $row)
             {
                $propertyid = $row->id;
                $landlord = $row->landlord_id;
                $refid = $year.$month.$propertyid.$landlord;                  


              $query = $this->db->get_where('vouchers', array('refid' => $refid));

                  if ($query->num_rows() == 0)
                  {

                    $this->db->select_sum('landlord_amount');
                        $query = $this->db->get_where('invoicepayments', 
                            array('month' => $month, 'year' => $year, 'propertyid'=> $propertyid));

                        foreach ($query->result() as $row)
                          {
                            $landlordamount = $row->landlord_amount;
                          }
            
                            $data = array(
                                'property_id' => $propertyid,
                                'landlord_id' => $landlord,
                                'amount' => $landlordamount,
                                'year' => $this->input->post('year'),
                                'month' => $this->input->post('month'),
                                'voucherdate' => date('Y-m-d'),
                                'paid' => 0,
                                'balance' => $landlordamount,
                                'refid' => $refid,
                                'status' => 'Due',
                            );

                          $insert = $this->vouchers_model->voucher_add($data);

                  }

                  else{

$this->db->select_sum('landlord_amount');
                        $query = $this->db->get_where('invoicepayments', 
                            array('month' => $month, 'year' => $year, 'propertyid'=> $propertyid));

                        foreach ($query->result() as $row)
                          {
                            $landlordamount = $row->landlord_amount;
                          }
            
                            $data = array(
                                'property_id' => $propertyid,
                                'landlord_id' => $landlord,
                                'amount' => $landlordamount,
                                'year' => $this->input->post('year'),
                                'month' => $this->input->post('month'),
                                'voucherdate' => date('Y-m-d'),
                                'paid' => 0,
                                'balance' => $landlordamount,
                                'refid' => $refid,
                                'status' => 'Due',
                            );

                    $this->db->where('refid', $refid);
                    $this->db->update('vouchers', $data);
                  }

             }
            echo json_encode(array("status" => FALSE));
        }
    

    public function ajax_edit($id) {
        $data = $this->vouchers_model->get_by_id($id);

        echo json_encode($data);
    }

    public function voucher_update() {

        $data = array(
            'property' => $this->input->post('property'),
            'month' => $this->input->post('month'),
        );

        $insert = $this->vouchers_model->voucher_update($data);
        echo json_encode(array("status" => TRUE));
    }

    public function voucher_delete($id) {

        $this->vouchers_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

    public function pdf($id) {

        $this->load->library('Pdf');
        $data['voucherid'] = $id;

        $this->load->view('reports/voucherpdf', $data);
    }

    public function editvoucher($id) {

        $this->mViewData['primarykey'] = $id;
        $this->render('_layouts/voucher-edit.php');

        // echo  $this->input->post('id');
    }

    public function payvoucher($id) {

        $this->mViewData['voucherid'] = $id;
        $this->render('_layouts/voucherpay.php');
    }

    public function addpayment() {

//        $this->db->trans_start(); # Starting Transaction
//        $this->db->trans_strict(FALSE); # See Note 01. If you wish can remove as well 

        $voucherid = $this->input->post('voucherid');

        $query = $this->db->get_where('vouchers', array('id' => $voucherid));
        foreach ($query->result() as $row) {
            
        }

        $balance = $this->input->post('balance');
        $paid = $this->input->post('paid');
        $amountpaid = $this->input->post('amountpaid');
        $newbalance = $balance - $amountpaid;
        $method = $this->input->post('method');

        $newpaid = $paid + $amountpaid;

        if ($newbalance > 0) {
            $status = 'Partial';
        }
        if ($newbalance == 0) {
            $status = 'Paid';
        }

        $data = array(
            'paid' => $newpaid,
            'balance' => $newbalance,
            'status' => $status,
        );
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $this->db->where('id', $voucherid);
        $this->db->update('vouchers', $data);

        $data2 = array(
            'landlordid' => $this->input->post('landlordid'),
            'propertyid' => $this->input->post('propertyid'),
            'voucherid' => $voucherid,
            'amount' => $amountpaid,
            'method' => $method,
            'date' => $this->input->post('date'),
            'refno' => $this->input->post('ref'),
            'record_creator' => $username,
        );



        $this->db->insert('voucherpayments', $data2);

//        $this->db->trans_complete();
//        if ($this->db->trans_status() === FALSE) {
//            # Something went wrong.
//            $this->db->trans_rollback();
//            return FALSE;
//        } else {
//            # Everything is Perfect. 
//            # Committing data to the database.
//            $this->db->trans_commit();
//            return TRUE;
//        }

        redirect('admin/vouchers');
    }

}
