<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Units extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('units_model');
    }

    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');

        $this->mViewData['units'] = $this->units_model->get_all_units();


        $this->render('_layouts/unit');
    }

    public function unitaudit($id) {

        $this->mViewData['propertyid'] = $id;
        $this->render('_layouts/unitaudit');
    }

    public function unit_add() {

        $qty = $this->input->post('quantity');
        $propertyid = $this->input->post('property_id');

        $query = $this->db->get_where('property', array('id' => $propertyid));

        foreach ($query->result() as $row) {
            $waterdeposit = $row->water_deposit;
            $elecdeposit = $row->electricity_deposit;
        }

        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $x = 1;

        while ($x <= $qty) {

            $data = array(
                'landlord_id' => $this->input->post('landlord_id'),
                'property_id' => $this->input->post('property_id'),
                'property_name' => $this->input->post('property_name'),
                'unit_code' => $this->input->post('codeprefix') . $x,
                'type' => $this->input->post('type'),
                'rent' => $this->input->post('rent'),
                'rent_deposit' => $this->input->post('deposit'),
                'water_deposit' => $waterdeposit,
                'electricity_deposit' => $elecdeposit,
                'status' => 'Vacant',
                'record_creator' => $username
            );


            $insert = $this->units_model->unit_add($data);

            $x++;
        }


        echo json_encode(array("status" => TRUE));
    }

    public function ajax_edit($id) {
        $data = $this->units_model->get_by_id($id);

        echo json_encode($data);
    }

    public function ajax_units($propertyid) {
        $data = $this->units_model->get_units($propertyid);
        echo json_encode($data);
    }

    public function unit_update() {

            $id = $this->input->post('id');             
            $unitcode  =  $this->input->post('unit_code');
            $type = $this->input->post('type');
            $rent = $this->input->post('rent');
            $rent_deposit = $this->input->post('rent_deposit');
            $water_deposit = $this->input->post('water_deposit');
            $electricity_deposit = $this->input->post('electricity_deposit');

 
 
           $data = array( 
             'unit_code' => $unitcode,
             'type' =>  $type,
             'rent' =>  $rent,
             'rent_deposit' =>  $rent_deposit,
             'water_deposit' =>  $water_deposit,
             'electricity_deposit' => $electricity_deposit

            );



        $this->units_model->unit_update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
        }


 
    public function unit_delete($id) {

        $this->units_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

}
