<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Settings extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('settings_model');
    }

    public function add_sms_settings() {
        $sms_status = $this->input->post('sms_status');
        $tenant_sms_status = $this->input->post('tenant_sms_status');
        $landlord_sms_status = $this->input->post('landlord_sms_status');
        $staff_sms_status = $this->input->post('staff_sms_status');

        $user = $this->ion_auth->user()->row();
        $username = $user->username;

        $data = array(
            'sms_status' => $sms_status,
            'tenant_notification' => $tenant_sms_status,
            'landlord_notification' => $landlord_sms_status,
            'staff_notification' => $staff_sms_status,
            'record_creator' => $username,
        );

        $id = 1;
        $this->db->where('id', $id);
        $this->db->update('settings', $data);
        $this->render('_layouts/settings');
    }

    public function add_tax_settings() {

        $tax_agency = $this->input->post('tax_agency');
        $pin = $this->input->post('pin');
        $rate = $this->input->post('rate');

        $user = $this->ion_auth->user()->row();
        $username = $user->username;

        $data = array(
            'tax_agency' => $tax_agency,
            'pin' => $pin,
            'rate' => $rate,
            'status' => 'Enabled',
            'record_creator' => $username,
        );

        $insert = $this->db->insert($data);
        echo json_encode(array("status" => TRUE));
    }

    public function update_tax_settings() {
        $id = 1;
        $status = $this->input->post('tax_status');

        $data = array(
            'status' => $status,
        );

        $this->db->where('id', $id);
        $this->db->update('tax', $data);

        $this->render('_layouts/settings');
    }

    public function add_office() {

        $type = $this->input->post('type');
        $name = $this->input->post('name');
        $location = $this->input->post('location');
        $address = $this->input->post('address');
        $phone_number = $this->input->post('phone_number');
        $alternate_phone = $this->input->post('alternate_phone_number');
        $email = $this->input->post('email');

        $user = $this->ion_auth->user()->row();
        $username = $user->username;

        $data = array(
            'type' => $type,
            'name' => $name,
            'location' => $location,
            'postal_address' => $address,
            'phone_number' => $phone_number,
            'alternate_phone_number' => $alternate_phone,
            'email' => $email,
            'record_creator' => $username,
        );

        $insert = $this->db->insert('offices', $data);

        echo json_encode(array("status" => TRUE));
    }

    public function update_office() {

        $id = $this->input->post('id');
        $type = $this->input->post('type');
        $name = $this->input->post('name');
        $location = $this->input->post('location');
        $address = $this->input->post('address');
        $phone_number = $this->input->post('phone_number');
        $alternate_phone = $this->input->post('alternate_phone_number');
        $email = $this->input->post('email');

        $user = $this->ion_auth->user()->row();
        $username = $user->username;

        $data = array(
            'type' => $type,
            'name' => $name,
            'location' => $location,
            'postal_address' => $address,
            'phone_number' => $phone_number,
            'alternate_phone_number' => $alternate_phone,
            'email' => $email,
            'record_creator' => $username,
        );

        $this->settings_model->update_office(array('id' => $id), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function update_sms_settings() {
        
    }

    public function ajax_edit($id) {

        $data = $this->settings_model->get_office_by_id($id);
        echo json_encode($data);
    }

}
