<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Landlords extends Admin_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('landlords_model');
    }
    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['landlords'] = $this->landlords_model->get_all_landlords();
        $this->render('_layouts/landlord');
    }
    public function add() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['landlords'] = $this->landlords_model->get_all_landlords();
        $this->render('_layouts/addLandlord');
    }
    public function landlord_add() {
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('fullname', 'Full Name', 'required');
        $this->form_validation->set_rules('idno', 'Id Number', 'required');
        $this->form_validation->set_rules('phone', 'Phone Number', 'required');
        if ($this->form_validation->run() == false) {
            echo validation_errors();
        } else {
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $data = array('fullname' => $this->input->post('fullname'), 
                          'idno' => $this->input->post('idno'), 
                          'phone' => $this->input->post('phone'), 
                          'email' => $this->input->post('email'), 
                          'bank' => $this->input->post('bank'), 
                          'postal' => $this->input->post('postal'), 
                          'branch' => $this->input->post('branch'), 
                          'account' => $this->input->post('account'), 
                          'record_creator' => $username,);
            $res = $this->landlords_model->landlord_add($data);
            if ($res == true) {
                //Send a Welcome SMS to Tenant
                $username = "jora";
                $apikey = "f78691be39edff5278c3ae8ac6b32fba291127ba1ec6a77b613bbd958500c77c";
                $recipients = $this->input->post('phone');
                $message = "Welcome to System";
                $from = "JORA-LTD";
                // Create a new instance of our awesome gateway class
                $gateway = new AfricasTalkingGateway($username, $apikey);
                $results = $gateway->sendMessage($recipients, $message, $from);
                foreach ($results as $result) {
                    // status is either "Success" or "error message"
                    // $phone=$result->number;
                    $status = $result->status;
                    $cost = $result->cost;
                }
                $this->session->set_flashdata('success', "Landlord added successfully");
                 redirect('admin/landlords');
                //echo json_encode(array("status" => TRUE));
                
            } else {
                $this->session->set_flashdata('error', "Record Not Inserted");
            }
        }
    }
    public function ajax_edit($id) {
        $data = $this->landlords_model->get_by_id($id);
        echo json_encode($data);
    }
    public function view_landlord($id) {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['id'] = $id;
        $this->render('_layouts/viewlandlord');
    }
    public function landlord_update() {
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $data = array('fullname' => $this->input->post('fullname'), 'idno' => $this->input->post('idno'), 'phone' => $this->input->post('phone'), 'email' => $this->input->post('email'), 'bank' => $this->input->post('bank'), 'postal' => $this->input->post('address'), 'branch' => $this->input->post('branch'), 'account' => $this->input->post('account'), 'record_creator' => $username,);
        $this->landlords_model->landlord_update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => true));
    }
    public function landlord_delete($id) {
        $this->landlords_model->delete_by_id($id);
        echo json_encode(array("status" => true));
    }
}
