<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Invoices extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->library('form_builder');
        $this->load->model('invoices_model');
    }

    public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $office = $user->office;
        $this->mViewData['office'] = $user->office;

        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');

        $this->mViewData['invoices'] = $this->invoices_model->get_all_invoices();


        

        $this->render('_layouts/invoice');
    }

    public function details($id) {


        $this->mViewData['invoiceid'] = $id;
        $this->render('_layouts/invoicedetails');

        echo $id;
    }

    public function payments() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');

        $this->mViewData['payments'] = $this->invoices_model->get_all_invoicepayments();
        $this->render('_layouts/invoicepayments');
    }

    public function paymentreverse($id) {

        $this->mViewData['primarykey'] = $id;


        $this->render('_layouts/invoicepaymentreverse');
    }

    public function addpaymentreverse() {

        $id = $this->input->post('id');
        $invno = $this->input->post('invno');
        $paidreverse = $this->input->post('paid');
        $method = $this->input->post('method');

        $query = $this->db->get_where('invoices', array('id' => $invno));

        $amount = $query->row('amount');

        $amountpaid = $query->row('paid');
        $amountbal = $query->row('balance');

        $newbal = $amountbal + $paidreverse;
        $newpaid = $amountpaid - $paidreverse;

        if ($amount == $newbal) {
            $status = 'Due';
        }

        if ($newbal < $amount) {
            $status = 'Partial';
        }

        $data = array(
            'paid' => $newpaid,
            'balance' => $newbal,
            'status' => $status,
        );

        $this->db->where('id', $invno);
        $this->db->update('invoices', $data);


        $data2 = array(
            'status' => 'Reversed',
            'reversaltime' => time(),
            'reversalreason' => $this->input->post('reason'),
        );

        $this->db->where('id', $id);
        $this->db->update('invoicepayments', $data2);

        redirect('admin/invoices/payments');
    }

    public function add_invoice_item() {

        $invoiceid = $this->input->post('invoiceid');
        $query = $this->db->get_where('invoices', array('id' => $invoiceid));

        $utilitybills = $query->row('utilitybills');
        $totalamount = $query->row('totalamount');

        $newtotalamount = $totalamount + $this->input->post('amount');
        $newtotalutility = $utilitybills + $this->input->post('amount');

        $data = array(
            'invoiceid' => $this->input->post('invoiceid'),
            'invoice_refno' => $this->input->post('refno'),
            'item_name' => $this->input->post('item_name'),
            'description' => $this->input->post('description'),
            'amount' => $this->input->post('amount'),
        );

        $this->db->insert('invoiceitems', $data);

        $data = array(
            'utilitybills' => $newtotalutility,
            'totalamount' => $newtotalamount,
        );

        $this->db->where('id', $invoiceid);
        $this->db->update('invoices', $data);

        echo json_encode(array("status" => TRUE));
    }

    public function invoice_add() {

        $property_id = $this->input->post('property');

        $query = $this->db->where('status', 'Active');

        $query = $this->db->get_where('subscription', array('property_id' => $property_id, 'status' => 'Active'));

        foreach ($query->result() as $row) {

            $property_id = $row->property_id;
            $unit_code = $row->unit_code;
            $tenant_id = $row->tenant_id;
            $rent = $row->rent;

            $refid = $this->input->post('year') . $this->input->post('month') . $this->input->post('unit') . $property_id . $unit_code;



            $this->db->where('refid', $refid);
            $query = $this->db->get('invoices');

            if ($query->num_rows() == 0) {

                $data = array(
                    'property_id' => $property_id,
                    'unit_code' => $unit_code,
                    'tenant_id' => $tenant_id,
                    'amount' => $rent,
                    'utilitybills' => 0,
                    'totalamount' => $rent,
                    'year' => $this->input->post('year'),
                    'month' => $this->input->post('month'),
                    'description' => 'Rent for ' . $this->input->post('month'),
                    'tax_status' => 'Taxable',
                    'commisionable' => 'Yes',
                    'status' => 'Due',
                    'balance' => $rent,
                    'invoicedate' => date('Y-m-d'),
                    'refid' => $refid,
                );

                $insert = $this->invoices_model->invoice_add($data);
            }
        }



        echo json_encode(array("status" => TRUE));
    }

    public function ajax_edit($id) {
        $data = $this->invoices_model->get_by_id($id);

        echo json_encode($data);
    }

    public function invoice_update() {

        $data = array(
            'property' => $this->input->post('property'),
            'month' => $this->input->post('month'),
        );

        $insert = $this->invoices_model->invoice_update($data);
        echo json_encode(array("status" => TRUE));
    }

    public function invoice_delete($id) {

        $this->invoices_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

    public function pdf($id) {

        $this->load->library('Pdf');
        $data['id'] = $id;

        $this->load->view('reports/invoicepdf', $data);
    }

    public function editinvoice($id) {

        $this->mViewData['primarykey'] = $id;
        $this->render('_layouts/invoice-edit.php');

        // echo  $this->input->post('id');
    }

    public function payinvoice($id) {

        $this->mViewData['invoiceid'] = $id;
        $this->render('_layouts/addpay.php');
    }

    public function receive_payment() {
        $tenantid = $this->input->post('tenantid');
        $amount_paid = $this->input->post('amountpaid');
        $method = $this->input->post('method');
        $reference = $this->input->post('refno');
        $date = $this->input->post('date');

        $this->db->where('tenant_id', $tenantid);
        $this->db->from('invoices');
        //$this->db->order_by('id', 'ASC');
        $this->db->where('status', 'Due');
        $query = $this->db->get();

        while ($amount_paid > 0) {
            foreach ($query->result() as $row) {
                $invoiceid = $row->id;
                $propertyid = $row->property_id;
                $tax_status = $row->tax_status;
                $invoice_amount = $row->balance;
                $commisionable = $row->commisionable;
                $year = $row->year;
                $month = $row->month;

                if ($invoice_amount > $amount_paid) {
                    $newbalance = $invoice_amount - $amount_paid;
                    $newpaid = $amount_paid;
                    $status = 'Partial';
                } else {
                    $newbalance = 0.00;
                    $newpaid = $invoice_amount;
                    $status = 'Paid';
                }
                if ($commisionable == "Yes") {
                    $commission = $rate / 100 * $amount_paid;
                }
                if ($tax_status == "Taxable") {
                    $vat = 16 / 100 * $commission;
                }

                $landlord_amount = $amount_paid - $commission;

                $data = array(
                    'paid' => $newpaid,
                    'balance' => $newbalance,
                    'status' => $status,
                );

                $user = $this->ion_auth->user()->row();
                $username = $user->username;
                $this->db->where('id', $invoiceid);
                $this->db->update('invoices', $data);

                $data2 = array(
                    'month' => $month,
                    'year' => $year,
                    'landlordid' => $landlordid,
                    'propertyid' => $propertyid,
                    'invoiceid' => $invoiceid,
                    'tenantid' => $tenantid,
                    'amount_paid' => $amount_paid,
                    'commission' => $commission,
                    'vat' => $vat,
                    'landlord_amount' => $landlord_amount,
                    'method' => $method,
                    'date' => $date,
                    'refno' => $reference,
                    'recordcreator' => $username,
                );
            }
            $this->db->insert('invoicepayments', $data2);
            $amount_paid = $amount_paid - $newpaid;
        }
        echo json_encode(array("status" => TRUE));
    }

    public function addpayment() {

        //        $this->db->trans_start(); # Starting Transaction
        //        $this->db->trans_strict(FALSE); # See Note 01. If you wish can remove as well 
        $bal = intval($this->input->post('balance'));
        $amt = intval($this->input->post('amountpaid'));

        if ($amt <= $bal) {

            $invoiceid = $this->input->post('invoiceid');

            $query = $this->db->get_where('invoices', array('id' => $invoiceid));
            foreach ($query->result() as $row) {
                $propertyid = $row->property_id;
                $tax_status = $row->tax_status;
                $description = $row->description;
                $commisionable = $row->commisionable;
            }

            $query = $this->db->get_where('property', array('id' => $propertyid));
            foreach ($query->result() as $row) {
                $landlordid = $row->landlord_id;
                $rate = $row->commission;
            }

            $query = $this->db->get_where('invoices', array('id' => $invoiceid));
            foreach ($query->result() as $row) {
                $tenantid = $row->tenant_id;
                $month = $row->month;
                $year = $row->year;
            }

            //$amount = $this->input->post('amount');
            $balance = $this->input->post('balance');
            $paid = $this->input->post('paid');
            $amountpaid = $this->input->post('amountpaid');
            $newbalance = intval($balance) - intval($amountpaid);
            if ($commisionable == "Yes") {
                $commission = $rate / 100 * $amountpaid;
            }
            
            if ($tax_status == "Taxable") {
                $vat = 16 / 100 * $commission;
            }

            $landlord_amount = $amountpaid - $commission;
            $method = $this->input->post('method');

            $newpaid = intval($paid) + intval($amountpaid);

            if ($newbalance > 0) {
                $status = 'Partial';
            }
            if ($newbalance == 0) {
                $status = 'Paid';
            }

            $data = array(
                'paid' => $newpaid,
                'balance' => $newbalance,
                'status' => $status,
            );
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $this->db->where('id', $invoiceid);
            $this->db->update('invoices', $data);

            $data2 = array(
                'month' => $month,
                'year' => $year,
                'landlordid' => $landlordid,
                'propertyid' => $propertyid,
                'invoiceid' => $invoiceid,
                'tenantid' => $tenantid,
                'amount_paid' => $amountpaid,
                'commission' => $commission,
                'vat' => $vat,
                'landlord_amount' => $landlord_amount,
                'method' => $method,
                'date' => $this->input->post('date'),
                'refno' => $this->input->post('refno'),
                'recordcreator' => $username,
                'status' => 'Paid',
            );

            $this->db->insert('invoicepayments', $data2);

            // echo json_encode(array("status" => TRUE));
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['id'] = $tenantid;

            redirect('admin/tenants');

           // $this->render('_layouts/viewtenant');

        } else {

            $this->session->set_flashdata('category_error', 'The amount you are paying is large than the balance.');
            redirect($_SERVER['HTTP_REFERER']);
        }
    }

}
