<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Departments extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
        $this->load->model('departments_model');
	}


	public function index()
	{
         $user = $this->ion_auth->user()->row();
         $loggeduserid =  $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id'=>$loggeduserid));
          $this->mViewData['usergroup']  = $query->row('group_id');

        $this->mViewData['departments'] =$this->departments_model->get_all_departments();
        

        		$this->render('_layouts/department');

    }
    
    public function department_add(){

        $data = array(
            'name' => $this->input->post('name'),
            'description' => $this->input->post('description'),
        );

        $insert = $this->departments_model->department_add($data);
        echo json_encode(array("status" => TRUE));
    }
    

    public function ajax_edit($id)
    {
        $data = $this->departments_model->get_by_id($id);

        echo json_encode($data);
    }

    public function department_update()

    {
        $data = array(


            'name' => $this->input->post('name'),
            'description' => $this->input->post('description'),


        );

        $this->departments_model->department_update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function department_delete($id){

        $this->departments_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

}
