<?php

  
    class MYPDF extends TCPDF {
        
   
    
}
// create new PDF document
$pdf = new MYPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Joel Mwas');
$pdf->SetTitle('Statement Report');
$pdf->SetSubject(' ');
$pdf->SetKeywords('');
$pdf->SetTextColor(0,0,0);
// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
    require_once(dirname(__FILE__).'/lang/eng.php');
    $pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('helveticaB', '', 12);

// set cell padding
$pdf->setCellPaddings(1, 1, 1, 1);

// set cell margins
$pdf->setCellMargins(1, 1, 1, 1);

// add a page
 $pdf->AddPage("L");




$html = <<<EOF
<div style="text-align:center; ">
<h2><u>PROPERTY STATEMENT REPORT</u></h2>
<p>START DATE: $start. END DATE: $end
</div>
EOF;

// output the HTML content
$pdf->writeHTML($html, true, false, true, false, '');
// -----------------------------------------------------------------------------




// -----------------------------------------------------------------------------

 

// -----------------------------------------------------------------------------

$tbl_header = '
<table style="text-align:center; font-size: 11px;" cellspacing="0" cellpadding="1" border="0.1"  rowspan="5"  >
<p><b>PAYMENTS RECORDS</b>  PROPERTY: '.$ppname.'</p>


<tr style="background-color:#fcfcfc">
     <th><b>INVOICE NO</b></th>
     <th><b>PAYMENT REF</b></th> 
     <th><b>DATE</b></th>
     <th><b>RENT PAID</b></th>
     <th><b>COMMISSION</b></th>
     <th><b>REVENUE</b></th>
</tr>

';
$tbl_footer = '</table>';
$tbl = '';
 if ($property =='ALL') {
 $query = $this->db->get_where('invoicepayments', array('date <=' => $start, 'date <=' => $end)); 
//$query = $this->db->get('invoicepayments'); 
}
else {

   $query = $this->db->get_where('invoicepayments', array('date >=' => $start, 'date <=' => $end, 'propertyid'=>$property));
}
// foreach item in your array...
  foreach ($query->result() as $row)    {
      
      
$tbl .= '
 <tr>
        <td style="border: 1px solid #000000; ">'.$row->invoiceid.'</td>
        <td style="border: 1px solid #000000; ">'.$row->refno.'</td>
        <td style="border: 1px solid #000000; ">'.$row->date.'</td>
        <td style="border: 1px solid #000000; ">'.number_format($row->amount_paid,2).'</td>
        <td style="border: 1px solid #000000; ">'.number_format($row->commission,2).'</td>
        <td style="border: 1px solid #000000; ">'.number_format($row->landlord_amount,2).'</td>
 
</tr>
    
';      

}

$pdf->writeHTML($tbl_header . $tbl . $tbl_footer, true, false, false, false, ''); 


$tbl = <<<EOD

<table style="text-align:center; font-size: 11px;" cellspacing="0" cellpadding="1" border="0"  rowspan="7"  >
   
<tr >
<td></td>
<td></td>
<td></td>
<td border="0.1"  style=" background-color: #C4C6C4 " ><b>TOTAL RENT <br>$total</b></td>
 <td border="0.1"  style=" background-color: #C4C6C4 "><b>TOTAL COMMISSION<br>$totalcomm</b></td>
<td border="0.1"  style=" background-color: #C4C6C4 "><b>TOTAL REVENUE<br>$totalrev</b></td>

</tr>

</table>


EOD;


$pdf->writeHTML($tbl, true, false, false, false, '');




// ------------Expenses-----------------------------------------------------------------

// -----------------------------------------------------------------------------

$tbl_header = '
<table cellpadding="1" border="0.1" style="text-align:center;" >

<p><b>EXPENSES RECORDS PROPERTY: '.$ppname.'</b> </p>

<tr cellpadding="2" border="1" style="text-align:center; font-size:10px; ">

    <th> <b>DATE </b></th>
    <th> <b>REF NO</b></th>
    <th> <b>PROPERTY </b></th>
    <th> <b>AMOUNT </b></th> 
    <th> <b>PAID TO</b></th> 
    <th> <b>NOTES </b></th>  
   
</tr>

';
$tbl_footer = '</table>';
$tbl = '';
$this->db->order_by("date", "asc");



 if ($property =='ALL') {
 $query1 = $this->db->get_where('expenses', array('date >=' => $start, 'date <=' => $end)); 
}
else {

   $query1 = $this->db->get_where('expenses', array('date >=' => $start, 'date <=' => $end, 'propertyid'=>$property));
}
// foreach item in your array...
  foreach ($query1->result() as $row)    {

    $query = $this->db->get_where('property', array('id'=>$row->propertyid ));

   foreach($query->result() as $pp){
    $ppname = $pp->property_name;
   }
      

      
$tbl .= '
 <tr>  
         <td style="border: 1px solid #000000; ">'.$row->date.'</td>
         <td style="border: 1px solid #000000; ">'.$row->refno.'</td>
         <td style="border: 1px solid #000000; ">'.$ppname.'</td>
         <td style="border: 1px solid #000000; ">'.number_format($row->amount,2).'</td>
         <td style="border: 1px solid #000000; ">'.$row->paidto.'</td>
         <td style="border: 1px solid #000000; ">'.$row->note.'</td>
 

</tr>
    
';

}

$tbl .='
<tr>
     <td></td>
    <td></td>
    <td></td>
    <td style=" background-color: #C4C6C4 "><b>TOTAL</b><br> <b> '.$totalexpenses.' </b> </td>
    <td></td>
    <td></td>
</tr>
';

$pdf->writeHTML($tbl_header . $tbl . $tbl_footer, true, false, false, false, '');



$tbl = <<<EOD

<table style="text-align:center; font-size: 11px;" cellspacing="0" cellpadding="1" border="0"  rowspan="7"  >
   
<tr>
<td></td>
<td></td>
 <td border="0.1" style="background-color: #C4C6C4"><b>TOTAL RENT <br>$total</b></td>
 <td border="0.1" style="background-color: #C4C6C4"><b>TOTAL COMMISSION<br>$totalcomm</b></td>
 <td border="0.1" style="background-color: #C4C6C4"><b>TOTAL EXPENSES<br>$totalexpenses</b></td>
<td border="0.1"  style="background-color: #C4C6C4"><b>TOTAL REVENUE<br>$totalearn</b></td>

</tr>

</table>


EOD;


$pdf->writeHTML($tbl, true, false, false, false, '');

// -----------------------------------------------------------------------------

 

// -----------------------------------------------------------------------------
$tbl = <<<EOD

<table cellspacing="0" cellpadding="0" border="0">
   
<tr>
<td width="450px;"> <i>Authorised Signature: _______________________________________ </i> </td>

</tr>

</table>


EOD;


$pdf->writeHTML($tbl, true, false, false, false, '');

// -----------------------------------------------------------------------------

$html = '

';
$pdf->writeHTML($html, true, false, true, false, '');

// -----------------------------------------------------------------------------

 

//Close and output PDF document
$pdf->Output('Property Statement Report.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
  
  