<h3>Patient Medical History</h3>
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
<?php 
    $sql = $this->db->get_where('patient', array('id'=>$pid));
    $dob = $sql->row('dob');
    $name = $sql->row('name');
    $b_g = $sql->row('blood_group');
    $gender = $sql->row("gender");
    $from = new DateTime($dob);
    $to   = new DateTime('today');
    $age = $from->diff($to)->y;

    $sql1 = $this->db->get_where('laboratory', array('visit_id'=>$id));
    $results = $sql1->row('results');
    $test = $sql1->row('test');
    $records_by = $sql1->row('record_creator');

    $sql2 = $this->db->get_where('prescription', array('visit_id'=>$id));
    $prescription = $sql2->row('prescription');
    $record_by = $sql2->row('prescribed_by');
    $dispensed_by = $sql2->row('dispensed_by');
    
    $sql3 = $this->db->get_where('consultation', array('visit_id'=>$id));
    $signs = $sql3->row('signs_symptoms');
    $notes = $sql3->row('clinical_notes');
    $general = $sql3->row('general_examination');
    $systemic = $sql3->row('systemic_examination');
    $history = $sql3->row('medical_history');
    $diagnosis = $sql3->row('diagnosis');
    $additional_notes = $sql3->row('additional_notes');
    $additional_notes_by = $sql3->row('additional_notes_by');
    $doctor = $sql3->row('record_creator');
;?>
<section class="content-header">
    <h1>
        <i class="fa fa-user"></i> Patient Account 
    </h1>
</section>
<section class="content">
    <?php echo form_open('admin/consultation/update'); ?>
    <div class="row">
    <div class="col-md-6">
        <label class="control-label">Full Name</label>
        <input name="name" value="<?php echo $name ?>" class="form-control" type="text" readonly>
    </div>
    <div class="col-md-6">
        <label class="control-label">Age</label>
        <input name="name" value="<?php echo $age ?>" class="form-control" type="text" readonly>
    </div>
   </div>
   <hr>
    <div class="row">
       <div class="col-md-12">
        <label class="control-label">Medical Record</label>
                                    <textarea class="summernote" name="vitals" readonly>
                                        <p><b>Vitals</b></p>
                                    <?php echo 'BP (mmHg) - '. $triage->blood_pressure .' / Temp (o^C) - '.  $triage->temperature .' H/W - '. $triage->height_weight .'/'. $triage->weight .' RBS (mmol/L) '. $triage->rbs 
       .' PR (/min) - '. $triage->pr .' RR (/min) - '. $triage->rr .' SpO2 (%) - '. $triage->spo; ?>
       <hr>
       <p><b>Presenting Symptoms</b></p>
       <?php echo $signs ;?>
       <hr>
       <p><b>Clinical Notes</b></p>
       <?php echo $notes ;?>
       <hr>
       <p><b>Past Medical / Surgical History</b></p>
       <?php echo $history ;?>
       <hr>
       <p><b>General Examination</b></p>
       <?php echo $general;?>
       <hr>
       <p><b>Systemic Examination</b></p>
       <?php echo $systemic ;?>
       <hr>
       <p><b>Lab Results</b></p>
       <?php echo $test ." - " . $results ?>
       <hr>
       <p><b>Prescription</b></p>
       <?php foreach ($sql2->result() as $row){
                                $prescription = $row->prescription;
                        ?>
                        <p><?php echo $prescription; ?></p>
                        <?php } ?>
                        <p><b>Addition Notes</b></p>
                        <p><?php echo $additional_notes; ?></p>
                        
       </textarea>
       
        <p>Triage Record By:  <?php echo $triage->record_creator; ?></p>
        <p>Consulting Doctor: <?php echo $doctor ?></p>
        <p>Additional Notes: <?php echo $additional_notes_by ?></p>
        <p>Prescribed By:  <?php echo $record_by; ?></p>
        <p>Dispensed By:   <?php echo $dispensed_by; ?></p>
        <hr>
</div>
        
        <!-- /.col -->
    </div>
    <!-- /.row -->
</form>
</section>

<!-- End Bootstrap modal -->
<script type="text/javascript">
     $(function () {
        //Initialize Select2 Elements
        $('.select2').select2()

        //Initialize Select2 Elements
        $('.select2bs4').select2({
          theme: 'bootstrap4'
        })
    });
</script>
<script>
                        function toTitleCase(str) {
                            return str.replace(/\w*/g, function (txt) {
                                return txt.charAt().toUpperCase() + txt.substr(1).toLowerCase();
                            });
                        }
</script>
<script>
    $(document).ready(function () {
        $("input[type='text']").blur(function () {
            var str = toTitleCase($(this).val());
            str = str.replace(/\s+/g, " ");
            str = str.replace(/(^\s+|\s+$)/g, "");
            $(this).val(str);
        });
    });</script>
<script>
    function isNumber(evt) {
        evt = (evt) ? evt : window.event;
        var charCode = (evt.which) ? evt.which : evt.keyCode;
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    }
</script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>
<script>
      $('.summernote').summernote({
        placeholder: 'Start Typing Here.......',
        tabsize: 2,
        height: 500,
        disable: true
      });
</script>
