<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Prescription_model extends CI_model
{
    var $table = 'prescription';
    
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    
    public function save($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }
    
    public function get_all()
    {
       $query=$this->db->get($this->table);
       return $query->result();
    }
    
    public function get_by_id_d($id,$date)
    {
        $this->db->from($this->table);
        $this->db->where('date',$date);
        $this->db->where('patient_id',$id);
        $query = $this->db->get();
 
        return $query->row();
    }
    
    public function get_by_id($id)
    {
        $this->db->from($this->table);
        $this->db->where('id',$id);
        $query = $this->db->get();
 
        return $query->row();
    }

    public function get_by_visitId($id)
    {
        $this->db->from($this->table);
        $this->db->where('visit_id',$id);
        $query = $this->db->get();
 
        return $query->row();
    }

    public function get_by_date($date) {
        $this->db->from($this->table);
        $this->db->where('date',$date);
        $query = $this->db->get();
 
        return $query->result();
    }
    
    public function get_by_department($department)
    {
        $this->db->from($this->table);
        $this->db->where('queue_to', $department);
        $query = $this->db->get();
 
        return $query->row();
    }
    
    public function update($where, $data)
    {
        $this->db->update($this->table, $data, $where);
        return $this->db->affected_rows();
    }
    
}