<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

class Expenses_model extends CI_Model
{

        var $table = 'expenses';

    public function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function get_all_expenses(){
        $this->db->order_by('id', 'DESC');

        $this->db->from('expenses');
        $query=$this->db->get();
        return $query->result();
    }

        public function get_by_id($id)
    {
        $this->db->from($this->table);
        $this->db->where('id',$id);
        $query = $this->db->get();
 
        return $query->row();
    }

    public function expense_add($data)
    {
        $this->db->insert($this->table, $data);
        return $this->db->insert_id();
    }

        public function expense_update($where, $data)
    {
        $this->db->update($this->table, $data, $where);
        return $this->db->affected_rows();
    }

        public function delete_by_id($id)
    {
        $this->db->where('id', $id);
        $this->db->delete($this->table);
    }
}

  