<?php
    defined('BASEPATH') OR exit('No direct script access allowed');
    class Reports extends Admin_Controller {
         public function __construct() {
            parent::__construct();
            $this->load->library('form_builder');
            $this->load->model('patients_model');
            $this->load->model('triage_model');
            $this->load->model('consultation_model');
            $this->load->model('laboratory_model');
            $this->load->model('visits_model');
            $this->load->model('prescription_model');
             }
        
        public function index(){
             $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->render('Report/index');
        }

        public function diagnosis(){
             $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->render('Report/diagnosis');
        }

        public function lab_report(){
             $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->render('Report/lab_report');
        }
     public function diagnosisreportpdf() {

        $this->load->library('Pdf');
        $date = explode('-', $this->input->post('date'));
        $startdate = str_replace('/','-',str_replace(" ", "", $date[0]));
        $enddate = str_replace('/','-',str_replace(" ", "", $date[1]));
        $data['age'] = $this->input->post('age');
        $data['start'] = $startdate;
        $data['end'] = $enddate;
        $this->load->view('Report/diagnosispdf',$data);


    }

    public function labreportpdf() {

        $this->load->library('Pdf');
        $this->load->library('Pdf');
        $date = explode('-', $this->input->post('date'));
        $startdate = str_replace('/','-',str_replace(" ", "", $date[0]));
        $enddate = str_replace('/','-',str_replace(" ", "", $date[1]));
        $data['age'] = $this->input->post('age');
        $data['start'] = $startdate;
        $data['end'] = $enddate;
        $this->load->view('Report/lab_reportpdf',$data);


    }

    public function patientlabreport($id,$pid) {

        $this->load->library('Pdf');
        $data['id'] = $id;
        $data['pid'] = $pid;
       $this->load->view('Report/labfindingsreportpdf',$data);
    }

    public function patientrecord($id,$pid) {
        $this->load->library('Pdf');
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $data['id'] = $id;
        $data['pid'] = $pid;
        $data['triage'] = $this->triage_model->get_by_visitId($id);
        $this->mViewData['consultation'] = $this->consultation_model->get_by_visitId($id);
        $this->mViewData['lab'] = $this->laboratory_model->get_by_visitId($id);
        $this->mViewData['prescription'] = $this->prescription_model->get_by_visitId($id);
       $this->load->view('Report/patientrecordpdf',$data);
    }

}
?>