<?php
defined('BASEPATH') OR exit('No direct script access allowed');
    class Laboratory extends Admin_Controller {
          public function __construct() {
            parent::__construct();
            $this->load->library('form_builder');
            $this->load->library('excel');
            $this->load->model('queue_model');
            $this->load->model('tests_model');
            $this->load->model('laboratory_model');
        }
        
        public function index() {
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['triage'] = $this->queue_model->get_by_department('Laboratory');
            $group_id = $query->row('group_id');
            $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
            if (strpos($sql->row('rights'), "Access Laboratory") !== false) {
                $this->render('Laboratory/index');
            } else {
                $this->render('errors/custom/access');
            }
        }

        public function tests() {
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['tests'] = $this->tests_model->get_all();
            $this->render('Laboratory/tests');
        }

        public function add_test() {
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->render('Laboratory/add_test');
        }

        public function search(){
                $user = $this->ion_auth->user()->row();
                $username = $user->username;
                $date = explode('-', $this->input->post('daterange'));
                $startdate = str_replace('/','-',str_replace(" ", "", $date[0]));
                $enddate = str_replace('/','-',str_replace(" ", "", $date[1]));
                $this->db->where('date >=', $startdate);
                $this->db->where('date <=', $enddate);
                $sql = $this->db->get('triage');
                $response = $sql->result();
                $this->mViewData['records'] = $response; //$this->triage_model->get_date_range($startdate,$enddate);
                $this->render('Laboratory/list');
        }

        public function edit_test($id) {
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['test'] = $this->tests_model->get_by_id($id);
            $this->render('Laboratory/edit_test');
        }

        public function add($id){
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['triage'] = $this->queue_model->get_by_id($id);
            $group_id = $query->row('group_id');
            $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
            if (strpos($sql->row('rights'), "Add Test Results") !== false) {
                $this->render('Laboratory/add');
            } else {
                $this->render('errors/custom/access');
            }    
        }

        public function edit($id){
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['triage'] = $this->laboratory_model->get_by_id($id);
            $group_id = $query->row('group_id');
            $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
            if (strpos($sql->row('rights'), "Edit Test Results") !== false) {
                $this->render('Laboratory/edit');
            } else {
                $this->render('errors/custom/access');
            }  
        }
        
        public function list(){
            $date = date('Y-m-d');
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['records'] = $this->laboratory_model->get_by_date($date);
            $group_id = $query->row('group_id');
            $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
            if (strpos($sql->row('rights'), "Access Laboratory") !== false) {
                $this->render('Laboratory/list');
            } else {
                $this->render('errors/custom/access');
            }  
        }

        public function save_test() {
            //Logged In User Session
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $q_id = $this->input->post("q_id");
            $date = date('Y-m-d');

            $data = array (
                'name' => $this->input->post('name'),
                'description' => $this->input->post('description'),
                'normal_results' => $this->input->post('normal_results'),
                'cost' => $this->input->post('cost'),
            );
            $res = $this->tests_model->save($data);
            if ($res == true){
                redirect('admin/laboratory/tests');
            }else{
                 $this->session->set_flashdata('error', "Record Not Inserted");
            }

        }

        public function update_test() {
            //Logged In User Session
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $q_id = $this->input->post("q_id");
            $date = date('Y-m-d');

            $data = array (
                'name' => $this->input->post('name'),
                'description' => $this->input->post('description'),
                'normal_results' => $this->input->post('normal_results'),
                'cost' => $this->input->post('cost'),
            );

            $this->db->where('id',$this->input->post('id'));
            $res = $this->db->update('medical_tests',$data);
            if ($res == true){
                redirect('admin/laboratory/tests');
            }else{
                 $this->session->set_flashdata('error', "Record Not Inserted");
            }

        }


        
        public function save() {
            //Logged In User Session
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $q_id = $this->input->post("q_id");
            $date = date('Y-m-d');
            
             //Validation
            $this->load->helper(array('form', 'url'));
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters('', '');
            $this->form_validation->set_rules('id', 'Patient Name', 'required');
            $this->form_validation->set_rules('test', 'Test', 'required');
            $this->form_validation->set_rules('results', 'Results', 'required');
           if ($this->form_validation->run() == FALSE) {
                echo validation_errors();
            } else {
            $action = $this->input->post('action');
            $patient_id = $this->input->post("id");
            $sql = $this->db->get_where('visits', array('patient_id'=>$patient_id, 'date'=>$date));
            $visit_id = $sql->row('visit_id');

            $data = array (
                'visit_id' => $visit_id,
                'patient_id' => $patient_id,
                'date' => $date,
                'test' => $this->input->post("test"),
                'method' => $this->input->post("method"),
                'results' => $this->input->post("results"),
                'conclusion' => $this->input->post("conclusion"),
                'record_creator' => $username,
                );
             $res = $this->db->insert('laboratory',$data);
             $insert_id = $this->db->insert_id();
             if ($res == true) {
                 $data = array(
                     'status' => 'Attended'
                     );
                 $this->db->where('id', $q_id);
                 $this->db->update('queues', $data);

                 //Queue The Patient Back To Doctor
                 $data = array (
                    'patient_id' => $patient_id,
                    'queue_from' => 'Laboratory',
                    'queue_to' => 'Consultation',
                    'remarks' => 'Results Confidential',
                    'type' => 'Normal',
                    'record_creator' => $username
                );
                 $this->queue_model->save($data);
                 redirect('admin/reports/patientlabreport/'.$insert_id.'/'.$this->input->post("id"));
                } else {
                    $this->session->set_flashdata('error', "Record Not Inserted");
                    redirect('admin/laboratory/list');
                }
            }
        }

        public function update() {
            //Logged In User Session
            $user = $this->ion_auth->user()->row();
            $username = $user->username;
            $q_id = $this->input->post("q_id");
            $date = date('Y-m-d');
            
            
            $action = $this->input->post('action');
            $data = array (
                'results' => $this->input->post("results"),
                'record_creator' => $username,
                );
            $this->db->where('id', $this->input->post('id'));
            $res = $this->db->update('laboratory',$data);
            $insert_id = $this->db->insert_id();
            if ($res == true) {
                 $data = array(
                     'status' => 'Attended'
                     );
                 $this->db->where('id', $q_id);
                 $this->db->update('queues', $data);
                $this->session->set_flashdata('success', "Record Updated Successfully");
                redirect('admin/laboratory/list');
                } else {
                    $this->session->set_flashdata('error', "Record Not Inserted");
                    redirect('admin/laboratory/list');
                }
        }
        public function delete_record($id){
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $group_id = $query->row('group_id');
            $sql = $this->db->get_where('admin_groups', array('id'=>$group_id));
            if (strpos($sql->row('rights'), "Delete Clinical Record") !== false) {
                $this->laboratory_model->delete_by_id($id);
                echo json_encode(array("status" => TRUE));
            } else {
                echo json_encode(array("status" => FALSE));
            }
        }
        
    }
?>