<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Billing extends Admin_Controller {
    public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
        $this->load->model('patients_model');
        $this->load->model('billing_model');
	}
	
	public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['bills'] = $this->billing_model->get_all();
        $this->render('Billing/index');
    }
    
    public function add() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['patients'] = $this->patients_model->get_all();
        $this->render('Billing/add');
    }
    
    public function edit($id) {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['bill'] = $this->billing_model->get_by_id($id);
        $this->render('Billing/edit');
    }
    
    public function addpay($id) {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['bill'] = $this->billing_model->get_by_id($id);
        $this->render('Billing/addpay');
    }
    
    public function print($id, $pid) {
            $user = $this->ion_auth->user()->row();
            $loggeduserid = $user->id;
            $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
            $this->mViewData['usergroup'] = $query->row('group_id');
            $this->mViewData['bill'] = $this->billing_model->get_by_id($id);
            $this->mViewData['patient'] = $this->patients_model->get_by_id($pid);
            $this->render('Billing/print');
        }
    
    public function save(){
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        $date = date('y-m-d');
        $amount = $this->input->post('amount');
        $amount_paid = $this->input->post('amount_paid');
        $balance = $amount - $amount_paid;
        $status = "";
        $patient_id = $this->input->post('id');
        $pieces = explode(" ", $patient_id);
        $id = $pieces[sizeof($pieces) - 1];
        
        if ($balance == $amount) {
            $status = 'Due';
        } else if ($balance > 0) {
            $status = 'Partial';
        } else if ($balance <= 0) {
            $status = 'Paid';
        }
        
      $data = array (
            'patient_id' => $id,
            'date' => $date,
            'description' => $this->input->post('description'),
            'method' => $this->input->post('method'),
            'amount' => $amount,
            'paid' => $amount_paid,
            'status' => $status,
            'balance' => $balance,
            'record_creator' => $username,
        );
        
        $res = $this->billing_model->save($data);
        $insert_id = $this->db->insert_id();
        if ($res == true){
            $this->session->set_flashdata('success', "Record added Successfully");
            redirect('admin/billing/print/'.$insert_id.'/'.$id);
        } else {
            $this->session->set_flashdata('error', "Record Not Inserted");
            redirect('admin/billing');
        }
    }
    
    public function update(){
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        
        //Data
        $data = array (
            'patient_id' => $this->input->post('patient_id'),
            'description' => $this->input->post('description'),
            'amount' => $this->input->post('amount'),
            );
        $this->db->where('id', $this->input->post('id'));
        $res = $this->db->update('bills',$data);
        if ($res == true){
            $this->session->set_flashdata('success', "Record Updated Successfully");
            redirect('admin/billing');
        } else {
            $this->session->set_flashdata('error', "Record Not Updated");
            redirect('admin/billing');
        }
    }
    
	
}

?>