<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Appointment extends Admin_Controller {
    public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
        $this->load->model('appointment_model');
        $this->load->model('patients_model');
	}
	
	public function index() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['appointments'] = $this->appointment_model->get_all();
        $this->render('Appointments/index');
    }
    
    public function add() {
        $user = $this->ion_auth->user()->row();
        $loggeduserid = $user->id;
        $query = $this->db->get_where('admin_users_groups', array('user_id' => $loggeduserid));
        $this->mViewData['usergroup'] = $query->row('group_id');
        $this->mViewData['patients'] = $this->patients_model->get_all();
        $this->render('Appointments/add');
    }
    
    public function save(){
        //Logged In User Session
        $user = $this->ion_auth->user()->row();
        $username = $user->username;
        
        $data = array (
            'patient_id' => $this->input->post('patient_id'),
            'date' =>  $this->input->post('date'),
            'reason' =>  $this->input->post('reason'),
            'doctor' =>  $this->input->post('doctor'),
            );
            $res = $this->appointment_model->save($data);
            if ($res == true) {
            $this->session->set_flashdata('success', "Record added Successfully");
                 redirect('admin/appointment/index');
            } else {
                $this->session->set_flashdata('error', "Record Not Inserted");
                redirect('admin/appointment/index');
            }
    }
}
?>