<?php
$primary = $id;
$query = $this->db->get_where('landlord', array('id' => $id));

foreach ($query->result() as $row) {
    $name = $row->fullname;
    $phone = $row->phone;
    $address = $row->postal;
    $id = $row->idno;
    $email = $row->email;
    $bank = $row->bank;
    $branch = $row->branch;
    $account = $row->account;
}
?>
<section class="content-header">
    <h1>
        <i class="fa fa-user"></i> Landlord Account
    </h1>
</section>
<section class="content">
    <div class="row">
        <div class="col-md-3">
            <!-- Profile Image -->
            <div class="box box-primary">
                <div class="box-body box-profile">
                    <center>
                        <img class="profile-user-img img-responsive img-circle" 
                             src="<?php echo base_url(); ?>images/landlord.png" height="200" width="150" alt="User profile picture" />
                    </center>
                    <h3 class="profile-username text-center"><?php echo $name; ?></h3>

                    <ul class="list-group list-group-unbordered">
                        <li class="list-group-item">
                            <b>Phone Number</b> <a class="pull-right"><?php echo $phone; ?></a>
                        </li>
                        <li class="list-group-item">
                            <b>Postal Address</b> <a class="pull-right"><?php echo $address; ?></a>
                        </li>
                        <li class="list-group-item">
                            <b>Email</b> <a class="pull-right"><?php echo $email; ?></a>
                        </li>
                        <li class="list-group-item">
                            <b>ID NO</b> <a class="pull-right"><?php echo $id; ?></a>
                        </li>
                        <li class="list-group-item">
                            <b>Bank Name</b> <a class="pull-right"><?php echo $bank; ?></a>
                        </li>
                        <li class="list-group-item">
                            <b>Branch</b> <a class="pull-right"><?php echo $branch; ?></a>
                        </li>
                        <li class="list-group-item">
                            <b>Account</b> <a class="pull-right"><?php echo $account; ?></a>
                        </li>
                    </ul>

                </div>
                <!-- /.box-body -->
            </div>
        </div>
        <!-- /.box -->
        <!-- /.col -->
        <div class="col-md-9">
            <ul class="nav nav-pills mb-3" id="pills-tab" role="tablist">
  <li class="nav-item">
    <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab" aria-controls="pills-home" aria-selected="true">Properties</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab" aria-controls="pills-profile" aria-selected="false">Invoice Payments</a>
  </li>
  <li class="nav-item">
    <a class="nav-link" id="pills-contact-tab" data-toggle="pill" href="#pills-contact" role="tab" aria-controls="pills-contact" aria-selected="false">Agent Remitance</a>
  </li>
</ul>
<div class="tab-content" id="pills-tabContent">
  <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
      <div class="row">
                            <div class="col-xs-12">
                                <div class="box">
                                    <div class="box-body table-responsive no-padding">
                                        <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                            <thead>
                                                <tr>
                                                    <th>NAME</th>
                                                    <th>TYPE</th>
                                                    <th>LOCATION</th>
                                                    <th>COMMISSION % </th>

                                                    <th style="width:125px;">Action</th>

                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $query = $this->db->get_where('property', array('landlord_id' => $primary));
                                                foreach ($query->result() as $property) {
                                                    ?>
                                                    <tr>
                                                        <td><?php echo $property->property_name; ?> </td>
                                                        <td><?php echo $property->property_type; ?> </td>
                                                        <td><?php echo $property->location; ?> </td>
                                                        <td><?php echo $property->commission; ?> %</td>
                                                        <td>
                                                            <?php if ($usergroup == 1 || $usergroup == 2) { ?>

                                                                <button class="btn btn-warning" onclick="edit_property(<?php echo $property->id; ?>)"><i class="glyphicon glyphicon-pencil">Edit</i></button>
                                                                <a  class="btn btn-primary" href="<?php echo base_url(); ?>admin/properties/view_property/<?php echo $property->id; ?> "> 
                                                                    <i class="glyphicon fa fa-eye"></i></a>
                                                            <?php } else { ?>
                                                            <?php } ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>
                                            <tfoot>
                                                <tr>
                                                </tr>
                                            </tfoot>
                                        </table>

                                    </div><!-- /.box-body -->
                                </div><!-- /.box -->
                            </div>
                        </div>
  </div>
  <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">
      <div class="box">
                            <div class="box-body table-responsive no-padding">
                                <table id="table_invoices" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>INVOICE ID</th>                                                  
                                            <th>AMOUNT</th>
                                            <th>COMMISION AMOUNT</th>
                                            <th>VAT 16 %</th>
                                            <th>LANDLORD AMOUNT</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $query = $this->db->get_where('invoicepayments', array('landlordid' => $primary));
                                        foreach ($query->result() as $invoicepayment) {
                                            ?>
                                            <tr>
                                                <td><?php echo $invoicepayment->id; ?> </td>
                                                <td><?php echo $invoicepayment->amount_paid; ?> </td>
                                                <td><?php echo $invoicepayment->commission; ?> </td>
                                                <td><?php echo $invoicepayment->vat; ?> </td>
                                                <td><?php echo $invoicepayment->landlord_amount; ?> </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                        </tr>
                                    </tfoot>
                                </table>

                            </div><!-- /.box-body -->
                        </div><!-- /.box -->
  </div>
  <div class="tab-pane fade" id="pills-contact" role="tabpanel" aria-labelledby="pills-contact-tab"><div class="box">
                            <div class="box-body table-responsive no-padding">
                                <table id="table_payment" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                    <thead>
                                        <tr>
                                            <th>Ref</th>                                                  
                                            <th>Property</th>
                                            <th>Month</th>
                                            <th>Amount</th>
                                            <th>Balance</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $query = $this->db->get_where('vouchers', array('landlord_id' => $primary));
                                        foreach ($query->result() as $voucherpayment) {
                                            ?>
                                            <tr>
                                                <td><?php echo $voucherpayment->refid; ?> </td>
                                                <td><?php
                                                    $propertyid = $voucherpayment->property_id;
                                                    $query = $this->db->get_where('property', array('id' => $propertyid));
                                                    echo $query->row('property_name');
                                                    ?> </td>
                                                <td><?php echo $voucherpayment->month; ?> </td>
                                                <td><?php echo $voucherpayment->amount; ?> </td>
                                                <td><?php echo $voucherpayment->balance; ?> </td>
                                                <td><?php echo $voucherpayment->status; ?> </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                        </tr>
                                    </tfoot>
                                </table>

                            </div><!-- /.box-body -->
                        </div>
                    </div>
                     
                </div>
                 
            </div>
            
</div>
</div>

        <!-- /.col -->
    </div>
    <!-- /.row -->

</section>
<script type="text/javascript">
    $(document).ready(function () {
        $('#table_id').DataTable();
        $('#table_invoices').DataTable();
        $('#table_payment').DataTable();
    });
    var save_method; //for save method string
    var table;


    function add_property()
    {
        save_method = 'add';
        $('#form')[0].reset(); // reset form on modals
        $('#modal_form').modal('show'); // show bootstrap modal
        //$('.modal-title').text('Add Person'); // Set Title to Bootstrap modal title
    }

    function edit_property(id)
    {
        save_method = 'update';
        $('#form')[0].reset(); // reset form on modals

        //Ajax Load data from ajax
        $.ajax({
            url: "<?php echo site_url('admin/properties/ajax_edit/') ?>/" + id,
            type: "GET",
            dataType: "JSON",
            success: function (data)
            {

                $('[name="property_name"]').val(data.property_name);
                $('[name="landlord_id"]').val(data.landlord_id);
                $('[name="location"]').val(data.location);
                $('[name="commission"]').val(data.commission);
                $('[name="property_type"]').val(data.property_type);
                $('[name="office_branch"]').val(data.branch_id);
                $('[name="water_deposit"]').val(data.water_deposit);
                $('[name="electricity_deposit"]').val(data.electricity_deposit);
                $('[name="id"]').val(data.id);
                $('#modal_form').modal('show'); // show bootstrap modal when complete loaded
                $('.modal-title').text('Edit property'); // Set title to Bootstrap modal title

            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error get data from ajax');
            }
        });
    }



    function save()
    {
        var url;
        if (save_method === 'add')
        {
            url = "<?php echo base_url('admin/properties/property_add') ?>";
        } else
        {
            url = "<?php echo site_url('admin/properties/property_update') ?>";
        }

        // ajax adding data to database
        $.ajax({
            url: url,
            type: "POST",
            data: $('#form').serialize(),
            dataType: "JSON",
            success: function (data)
            {
                //if success close modal and reload ajax table
                $('#modal_form').modal('hide');
                $('[name="landlordid"]').val(data.landlord_id);
                location.reload();// for reload a page
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error adding / update data');
            }
        });
    }

    function delete_property(id)
    {
        if (confirm('Are you sure delete this data?'))
        {
            // ajax delete data from database
            $.ajax({
                url: "<?php echo site_url('admin/properties/property_delete') ?>/" + id,
                type: "POST",
                dataType: "JSON",
                success: function (data)
                {

                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert('Error deleting data');
                }
            });

        }
    }

</script>

<!-- Bootstrap modal -->
<div class="modal fade " id="modal_form" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h3 class="modal-title">Add New property</h3>
            </div>
            <div class="modal-body form">
                <form action="#" id="form" class="form-horizontal">
                    <!-- <input type="hidden" value="" name="id"/> -->
                    <div class="form-body">
                        <div class="form-group">
                            <label class="control-label col-md-3">Property Name</label><br>
                            <div class="col-md-9">
                                <input name="property_name" id="pName"  class="form-control" type="text" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Property Location</label><br>
                            <div class="col-md-9">
                                <input name="location"  class="form-control" type="text" required>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Property Type</label><br>
                            <div class="col-md-9">
                                <select class="form-control" name="property_type" required>
                                    <option value="">--Select Type--</option>
                                    <option>Apartment</option>
                                    <option>Commercial Building</option>
                                    <option>Traditional House</option>
                                    <option>Mansion</option>
                                    <option>Plot</option>
                                </select>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Property Landlord</label><br>
                            <div class="col-md-9">
                                <select name="landlord_id" class="form-control" required="">
                                    <?php
                                    $query = $this->db->get_where('landlord', array('id' => $primary));
                                    foreach ($query->result() as $row) {
                                        ?>
                                        <option value="<?php echo $row->id ?>"><?php echo $row->fullname; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Office Branch</label><br>
                            <div class="col-md-9">
                                <select name="office_branch" class="form-control" required="">
                                    <option value="">--Select Office--</option>
                                    <?php
                                    $query = $this->db->get('offices');
                                    foreach ($query->result() as $row) {
                                        ?>
                                        <option value="<?php echo $row->id; ?>"><?php echo $row->name; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Commission in Percentage</label><br>
                            <div class="col-md-9">
                                <input name="commission" onkeypress="return isNumber(event)"  class="form-control" type="text">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Water Deposit</label><br>
                            <div class="col-md-9">
                                <input name="water_deposit" onkeypress="return isNumber(event)"  class="form-control" type="text">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Electricity Deposit</label><br>
                            <div class="col-md-9">
                                <input name="electricity_deposit" onkeypress="return isNumber(event)"  class="form-control" type="text">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" id="btnSave" onclick="save()" class="btn btn-primary">Save</button>
                        <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<!-- /.modal -->
<!-- End Bootstrap modal -->
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.1/dist/js/bootstrap.bundle.min.js"></script>

