<div class="container">
    <!-- Content Header (Page header) -->
  
    <row>
            <div class="col-md-6">
                <div class="box box-default collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title">SMS Settings</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i>
                            </button>
                        </div>
                        <!-- /.box-tools -->
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <form method="post" action="<?php echo site_url('admin/settings/add_sms_settings'); ?>">
                            <div class="form-body">
                                <div class="form-group col-md-5">
                                    <label class="control-label">SMS Notification</label><br>
                                    <label>
                                        <input type="radio" name="sms_status" value="Enabled" class="minimal">
                                        Enable
                                    </label>
                                    <label>
                                        <input type="radio" name="sms_status" value="Disabled" class="minimal">
                                        Disable
                                    </label>
                                </div>  
                                <div class="form-group col-md-5">
                                    <label class="control-label ">Tenant Notification</label><br>
                                    <label>
                                        <input type="radio" name="tenant_sms_status" value="Enabled" class="minimal">
                                        Enable
                                    </label>
                                    <label>
                                        <input type="radio" name="tenant_sms_status" value="Disabled" class="minimal">
                                        Disable
                                    </label>
                                </div>
                                <div class="form-group col-md-5">
                                    <label class="control-label ">Landlord Notification</label><br>
                                    <label>
                                        <input type="radio" name="landlord_sms_status" value="Enabled" class="minimal">
                                        Enable
                                    </label>
                                    <label>
                                        <input type="radio" name="landlord_sms_status" value="Disabled" class="minimal">
                                        Disable
                                    </label>
                                </div>
                                <div class="form-group col-md-5">
                                    <label class="control-label ">Staff Notifications</label><br>
                                    <label>
                                        <input type="radio" name="staff_sms_status" value="Enabled" class="minimal">
                                        Enable
                                    </label>
                                    <label>
                                        <input type="radio" name="staff_sms_status" value="Disabled" class="minimal">
                                        Disable
                                    </label>
                                </div>
                            </div>
                            <button type="submit" id="btnSave" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
                <!-- /.box-body -->
            </div>
            <!-- /.box -->
            <div class="col-md-6">
                <div class="box box-default collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title">Tax Settings</h3>

                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i>
                            </button>
                        </div>
                        <!-- /.box-tools -->
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-12 text-right">
                                <div class="form-group">
                                    <a class="btn btn-primary" onclick="tax_settings()"><i class="fa fa-plus"></i> Tax Settings</a>
                                </div>
                            </div>
                        </div>
                        <form role="form" method="post" action="<?php echo site_url('admin/settings/update_tax_settings'); ?>">
                            <div class="form-body">
                                <div class="form-group">
                                    <label>
                                        <input type="radio" name="tax_status" value="Enabled" class="minimal" >
                                        Enable Tax
                                    </label>
                                </div>
                                <div class="form-group">
                                    <label>
                                        <input type="radio" name="tax_status" value="Disabled" class="minimal">
                                        Disable Tax
                                    </label>
                                </div>  
                            </div>
                            <button type="submit" id="btnSave" ty class="btn btn-primary">Update</button>
                        </form>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>
        </row>
        <row>
            <div class="col-md-12">
                <div class="box box-default collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title">Branch Offices</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i>
                            </button>
                        </div>
                        <!-- /.box-tools -->
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-12 text-right">
                                <div class="form-group">
                                    <a class="btn btn-primary" onclick="add_office()"><i class="fa fa-plus"></i>Add Branch</a>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="box">            
                                    <div class="box-body table-responsive no-padding">
                                        <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Branch Name</th>
                                                    <th>Physical Location</th>
                                                    <th>Postal Address</th>
                                                    <th>Primary Phone Number</th>
                                                    <th>Alternate Phone Number</th>
                                                    <th>Email</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php
                                                $query = $this->db->get('offices');
                                                foreach ($query->result() as $row) {
                                                    ?>
                                                    <tr>

                                                        <td><?php echo $row->id; ?></td>
                                                        <td><?php echo $row->name; ?></td>
                                                        <td><?php echo $row->location; ?></td>
                                                        <td><?php echo $row->postal_address; ?></td>
                                                        <td><?php echo $row->phone_number; ?></td>
                                                        <td><?php echo $row->alternate_phone_number; ?></td>
                                                        <td><?php echo $row->email; ?></td>
                                                        <td>
                                                            <button class="btn btn-warning" onclick="edit_office(<?php echo $row->id; ?>)"><i class="glyphicon glyphicon-pencil"></i></button>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            </tbody>

                                        </table>
                                    </div><!-- /.box-body -->
                                </div><!-- /.box -->
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>

        </row>

    
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('#table_id').DataTable();
    });
    var save_method; //for save method string
    var table;


    function tax_settings()
    {
        save_method = 'add';
        $('#form')[0].reset(); // reset form on modals
        $('#modal_form').modal('show'); // show bootstrap modal
        //$('.modal-title').text('Add Person'); // Set Title to Bootstrap modal title
    }
    function add_office()
    {
        save_method = 'add';
        $('#form_branch')[0].reset(); // reset form on modals
        $('#modal_form_branch').modal('show'); // show bootstrap modal
        //$('.modal-title').text('Add Person'); // Set Title to Bootstrap modal title
    }

    function edit_office(id)
    {
        save_method = 'update';
        $('#form_branch')[0].reset(); // reset form on modals

        //Ajax Load data from ajax
        $.ajax({
            url: "<?php echo site_url('admin/settings/ajax_edit/') ?>/" + id,
            type: "GET",
            dataType: "JSON",
            success: function (data)
            {

                $('[name="name"]').val(data.name);
                $('[name="location"]').val(data.location);
                $('[name="address"]').val(data.postal_address);
                $('[name="phone_number"]').val(data.phone_number);
                $('[name="alternate_phone_number"]').val(data.alternate_phone_number);
                $('[name="email"]').val(data.email);
                $('[name="id"]').val(data.id);

                $('#modal_form_branch').modal('show'); // show bootstrap modal when complete loaded
                $('.modal-title').text('Edit Office'); // Set title to Bootstrap modal title

            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error get data from ajax');
            }
        });
    }



    function save()
    {
        var url;
        if (save_method == 'add')
        {
            url = "<?php echo base_url('admin/settings/add_office') ?>";
        } else
        {
            url = "<?php echo site_url('admin/settings/update_office') ?>";
        }

        // ajax adding data to database
        $.ajax({
            url: url,
            type: "POST",
            data: $('#form_branch').serialize(),
            dataType: "JSON",
            success: function (data)
            {
                //if success close modal and reload ajax table
                $('#modal_form_branch').modal('hide');
                location.reload();// for reload a page
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error adding / update data');
            }
        });
    }

    function set_tax()
    {
        var url;
        if (save_method == 'add')
        {
            url = "<?php echo base_url('admin/settings/add_tax_settings') ?>";
        } else
        {
            url = "<?php echo site_url('admin/settings/update_tax_settings') ?>";
        }

        // ajax adding data to database
        $.ajax({
            url: url,
            type: "POST",
            data: $('#form').serialize(),
            dataType: "JSON",
            success: function (data)
            {
                //if success close modal and reload ajax table
                $('#modal_form').modal('hide');
                location.reload();// for reload a page
            },
            error: function (jqXHR, textStatus, errorThrown)
            {
                alert('Error adding / update data');
            }
        });
    }

    function delete_subscription(id)
    {
        if (confirm('Are you sure delete this data?'))
        {
            // ajax delete data from database
            $.ajax({
                url: "<?php echo site_url('admin/subscriptions/subscription_delete') ?>/" + id,
                type: "POST",
                dataType: "JSON",
                success: function (data)
                {
                    location.reload();
                },
                error: function (jqXHR, textStatus, errorThrown)
                {
                    alert('Error deleting data');
                }
            });

        }
    }

</script>

<!-- Bootstrap modal -->
<div class="modal fade" id="modal_form" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h3 class="modal-title">Tax Settings</h3>
            </div>
            <div class="modal-body form">
                <form action="#" id="form" class="form-horizontal">

                    <div class="form-body">
                        <div class="form-group">
                            <label class="control-label col-md-3">Tax Agency</label><br>
                            <div class="col-md-9">
                                <select class="form-control" name="tax_agency">
                                    <option>Kenya Revenue Authority</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">TAX PIN</label><br>
                            <div class="col-md-9">
                                <input name="pin"   class="form-control" type="text">

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Rate</label>
                            <div class="col-md-9">
                                <input name="rate"  class="form-control" type="number">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="btnSave" onclick="set_tax()" class="btn btn-primary">Save</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<div class="modal fade" id="modal_form_branch" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h3 class="modal-title">Add Office</h3>
            </div>
            <div class="modal-body form">
                <form action="#" id="form_branch" class="form-horizontal">
                    <div class="form-body">
                        <input type="hidden" value="<?php echo $row->id; ?>" name="id"/>
                        <div class="form-group">
                            <label class="control-label col-md-3">Office Type</label><br>
                            <div class="col-md-9">
                                <select class="form-control" name="type">
                                    <option>Head Office</option>
                                    <option>Branch Office</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Name</label><br>
                            <div class="col-md-9">
                                <input name="name"  class="form-control" type="text">

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Location</label>
                            <div class="col-md-9">
                                <input name="location"  class="form-control" type="text">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Postal Address</label>
                            <div class="col-md-9">
                                <input name="address"  class="form-control" type="text">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Phone Number</label>
                            <div class="col-md-9">
                                <input name="phone_number"  class="form-control" type="number">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Alternate Phone Number</label>
                            <div class="col-md-9">
                                <input name="alternate_phone_number"  class="form-control" type="text">
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="control-label col-md-3">Email Address</label>
                            <div class="col-md-9">
                                <input name="email"  class="form-control" type="email">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" id="btnSave" onclick="save()" class="btn btn-primary">Save</button>
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cancel</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div>
<!-- End Bootstrap modal -->

<!--<script src="<?php echo base_url('assests/js/jquery-3.2.1.min.js') ?>"></script>-->
<!--<script src="<?php echo base_url('assests/datatables/js/jquery.dataTables.min.js') ?>"></script>-->
<!--<script src="<?php echo base_url('assests/datatables/js/dataTablesbootstrap.js') ?>"></script>-->
