
<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payslip extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
	}


	public function bulkslips()
	{				
		$this->render('bulkpayslips');
	}



  	public function payslips()
	{
	    
		$crud = $this->generate_crud('payslip');
	 
	    $crud->set_relation('Full_Name', 'employees', 'Full_Name');

		 $crud->field_type('emp', 'hidden');
		 $crud->field_type('Taxable_Pay', 'hidden');
		 $crud->field_type('Tax_Charged', 'hidden');
		 $crud->field_type('Less_Deductions', 'hidden');
		 $crud->field_type('Nett_Pay', 'hidden');
		 $crud->field_type('Gross_Pay', 'hidden');
		 $crud->field_type('Employee', 'hidden');
		 $crud->field_type('Basic_Pay', 'hidden');
		 $crud->field_type('Allowances', 'hidden');
		 $crud->field_type('ADVANCE', 'hidden');
		 $crud->field_type('NSSF', 'hidden');
		 $crud->field_type('NHIF', 'hidden');
		 $crud->field_type('PAYE', 'hidden');
		 $crud->field_type('Relief', 'hidden');
		 $crud->field_type('Ref_Code', 'hidden');

		 $crud->columns(array('emp', 'Gross_Pay','Less_Deductions','Loan_Payment','Nett_Pay','Month','Year','Status','Posted_By'));

		 
		 $crud->add_action('View Pdf Payslip', '', 'admin/home/payslippdf','fa fa-file-pdf-o ');
		 
       $crud->field_type('Month','dropdown',
       array('JANUARY' => 'JANUARY', 'FEBRUARY' => 'FEBRUARY', 'MARCH'=>'MARCH', 'APRIL'=> 'APRIL', 'MAY'=>'MAY', 'JUNE'=>'JUNE', 'JULY'=>'JULY', 'AUGUST'=>'AUGUST', 'SEPTEMBER' => 'SEPTEMBER', 'OCTOBER'=>'OCTOBER', 'NOVEMBER'=>'NOVEMBER', 'DECEMBER'=>'DECEMBER'));
            
        $crud->field_type('Status','dropdown',
            array('PENDING' => 'PENDING', 'PAID' => 'PAID'));
            

          $crud->field_type('Year','dropdown',
            array(
                
                '2015' => '2015',
                '2016' => '2016',
                '2017' => '2017',
                '2018' => '2018',
                '2019' => '2019',
                '2020' => '2020',
                '2021' => '2021',
                '2022' => '2022',
                '2023' => '2023',
                '2024' => '2024',
                '2025' => '2025',
                '2026' => '2026',
                '2027' => '2027',
                '2028' => '2028',
                '2029' => '2029',
                '2030' => '2030',
                '2031' => '2031',
                '2032' => '2032',
                '2033' => '2033',
                '2034' => '2034',
                '2035' => '2035',               
                
                )); 
         $crud->callback_before_insert(array($this,'payslip_callback'));
        
       $crud->callback_before_update(array($this,'payslipupdate_callback'));

       $crud->edit_fields('Status','Other_Deductions_Amount','Other_Deductions_Note');

       $crud->set_read_fields('Status','Other_Deductions_Amount','Other_Deductions_Note');

     

        $this->mPageTitle = 'Employees Salaries Payslips';

		$this->render_crud();
		     
	}
	
	
// update other deduction --> updAte Less Deductions 

	public function payslipupdate_callback($post_array, $primary_key) {

		 $user = $this->ion_auth->user()->row();

		
		//Update db to remove previous total ... less deduction ... net pay
	    $query = $this->db->get_where('payslip' , array('id' => $primary_key ));

	    $lessdeductions = $query->row('Less_Deductions');
	    $olddeductions = $query->row('Other_Deductions_Amount');
	    $netpayold = $query->row('Nett_Pay');
	    $newlessdedaction = $lessdeductions - $olddeductions;
	    $newnetpay = $netpayold + $olddeductions ;

	     $data = array(
		 	
		 	'Less_Deductions'=> $newlessdedaction,
		 	'Nett_Pay' => $newnetpay,
		 );
		
		$this->db->where('id', $primary_key);
	    $this->db->update('payslip', $data);







	//Update db  total ... less deduction ... net pay

       $query2 = $this->db->get_where('payslip' , array('id' => $primary_key ));

	    $netpay = $query2->row('Nett_Pay');	
	    $finallessdeductions = $query2->row('Less_Deductions');    

		$otherdeductions =  $post_array['Other_Deductions_Amount'];		

		$ttdeductions = $otherdeductions + $finallessdeductions ;

		$newnet = $netpay - $otherdeductions ;


		$data2 = array(

			'Less_Deductions' => $ttdeductions,
			'Nett_Pay'		  => $newnet,
			'Posted_By'       => $user->username,
		);

		
		$this->db->where('id', $primary_key);
	    $this->db->update('payslip', $data2);
	 

	    
		return $post_array;

	}

	
	//payslip callback
	
	public function payslip_callback($post_array) {

		 $user = $this->ion_auth->user()->row();

		 $post_array['Posted_By']=	$user->username;

		$empname =  $post_array['Full_Name'];

		$yr   = $post_array['Year'];
		$mn   =  $post_array['Month'] ;

		$otherdeductions =  $post_array['Other_Deductions_Amount'];	


	    
	    $q = $this->db->get_where('employees' , array('id' => $empname ));

	    $empno = $q->row('Employee_Id');



	    $query = $this->db->get_where('employees' , array('Employee_Id' => $empno ));

				foreach ($query->result() as $row)
				{
				        
				    
				     $empid = $row->id;

				     $nssf =  $row->NSSF_Amount;
				     $nhif =  $row->NHIF_Amount;
				     $tpay = $row->Monthly_Basic_Pay + $row->Allowances_Amount;

				     $taxablepay = $tpay - $nssf ;

				     $paye = 0;

				     if ( $taxablepay >= 13486 && $taxablepay <= 23885 ){

				     	$b1 = 0.1 * 12298 ;

				     	$bb1 = $taxablepay -12298 ;

				     	$b2 = 0.15 * $bb1;

				     	$incometax = $b1 + $b2 ;

				     	$paye = $incometax - 1408 ;

				     }		

				     if ( $taxablepay >= 23886 && $taxablepay <= 35472 ){

				     	$b1 = 0.1 * 12298 ;
				     	$b2 = 0.15 * 11587;

				     	$bb1 = $taxablepay - 23885 ;

				     	$b3 = 0.2 * $bb1;


				     	$incometax = $b1 + $b2 + $b3 ;

				     	$paye = $incometax -1408 ;
				     }	


				    if ( $taxablepay >= 35473 && $taxablepay <= 47059 ){

				     	$b1 = 0.1 * 12298 ;
				     	$b2 = 0.15 * 11587;
				     	$b3 = 0.2 * 11587;

				     	$bb1 = $taxablepay - 35473 ;

				     	$b4 = 0.25 * $bb1;

				     	$incometax  = $b1 + $b2 + $b3 + $b4 ;

				     	$paye = $incometax -1408 ;


				     }	

				      if ( $taxablepay >=  47060 ){

				     	$b1 = 0.1 * 12298 ;
				     	$b2 = 0.15 * 11587;
				     	$b3 = 0.2 * 11587;
				     	$b4 = 0.25 * 11587;

				     	$bb1 = $taxablepay - 47060 ;

				     	$b5 = 0.3 * $bb1;

				     	$incometax  = $b1 + $b2 + $b3 + $b4 + $b5 ;
				     	$paye = $incometax -1408 ;	     	


				     }	



	

					  $post_array['Employee']      	 	= $row->id;
					  $post_array['emp']		    	= $row->Employee_Id;
					  $post_array['Full_Name']			= $row->Full_Name;
					  $post_array['Basic_Pay'] 			= $row->Monthly_Basic_Pay;
					  $post_array['Allowances'] 		= $row->Allowances_Amount;
					  $post_array['Gross_Pay'] 			= $row->Monthly_Basic_Pay + $row->Allowances_Amount;
					  $post_array['NSSF'] 				= $row->NSSF_Amount;
					  $post_array['NHIF'] 				= $row->NHIF_Amount;
					  $post_array['PAYE'] 				= $paye;
					  $post_array['Relief'] 			= 1408;
					  $post_array['Taxable_Pay'] 		= $row->Monthly_Basic_Pay + $row->Allowances_Amount - $row->NSSF_Amount;
					  $post_array['Month'] 			    = $mn;
					  $post_array['Year'] 				= $yr;
					  $post_array['Date'] 				= date("Y-m-d");
					  $post_array['Ref_Code']		    = $row->Employee_Id.$mn.$yr;
					  $post_array['Status'] 			= 'PENDING';


				}


					  $this->db->select_sum('Amount');

					  $query2 = $this->db->get_where('advance', array('employee' => $empid, 'month'=>$mn, 'year'=>$yr ) );


									foreach ($query2->result() as $row)

									{								        

									   $advancesum  = $row->Amount;
									   $deductions = $advancesum + $nssf + $nhif + $paye + $otherdeductions ;						    
									     
									   $post_array['ADVANCE'] = $adsum;
									   $post_array['Less_Deductions']  = $deductions;
									   $post_array['Nett_Pay'] 	 = $tpay - $deductions;									      

								 }  							   
	     
					

					  return $post_array;     

			}	   

      
  }