<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Expenses extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('form_builder');
        $this->load->model('expenses_model');
	}


	public function index()
	{
          $user = $this->ion_auth->user()->row();
         $loggeduserid =  $user->id;
         $query = $this->db->get_where('admin_users_groups', array('user_id'=>$loggeduserid));
          $this->mViewData['usergroup']  = $query->row('group_id');
         
        $this->mViewData['expenses'] =$this->expenses_model->get_all_expenses();
        
       // echo $uid; 

        	$this->render('_layouts/expense');

    }
    
    
    public function expenseview()
    {
        

        $this->render('_layouts/expenseadd');

    }
    
    
    public function expense_add(){

        $data = array(
            'type' => $this->input->post('type'),
            'description' => $this->input->post('description'),
            'amount' => $this->input->post('amount'),
            'propertyid' =>$this->input->post('propertyid'),
            'paidto' => $this->input->post('paidto'),    
            'date' => $this->input->post('date'),
            'refno' => $this->input->post('refno'),
        );

          $insert = $this->expenses_model->expense_add($data);
        echo json_encode(array("status" => TRUE));
    }
    
    

    public function ajax_edit($id)
    {
        $data = $this->expenses_model->get_by_id($id);

        echo json_encode($data);
    }

    public function expense_update()

    {
        $data = array(
            'type' => $this->input->post('type'),
            'description' => $this->input->post('description'),
            'amount' => $this->input->post('amount'),
            'propertyid' =>$this->input->post('propertyid'),
            'paidto' => $this->input->post('paidto'),
                'refno' => $this->input->post('refno'),

            'date' => $this->input->post('date'),
        );

        $this->expenses_model->expense_update(array('id' => $this->input->post('id')), $data);
        echo json_encode(array("status" => TRUE));
    }


public function pdf($id) {



        $this->load->library('Pdf');
        $data['id'] = $id;

 
        $this->load->view('reports/expensepdf', $data);



    }

    public function expense_delete($id){

        $this->expenses_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }

}
